/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.SuperBosses;
import com.cheeseman.superbosses.SuperBossesClass;
import com.cheeseman.superbosses.config.CommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="superbosses")
public class HardcodedDropMultiplier {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity mob = event.getEntity();
        String mobId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType()).toString();
        if (mobId == null || !((List)CommonConfig.hardcodedBosses.get()).contains(mobId)) {
            return;
        }
        SuperBosses.LOGGER.info("FOUND HARDCODED BOSS. DUPING DROPS");
        Collection drops = event.getDrops();
        int bonusRolls = SuperBossesClass.getMobBonusRolls(mob);
        if (bonusRolls <= 0) {
            return;
        }
        ArrayList<ItemEntity> bonusDrops = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : drops) {
            ItemStack stack = itemEntity.getItem();
            for (int i = 0; i < bonusRolls; ++i) {
                ItemStack bonusStack = stack.copy();
                bonusDrops.add(new ItemEntity(mob.level(), mob.getX(), mob.getY(), mob.getZ(), bonusStack));
            }
        }
        drops.addAll(bonusDrops);
    }
}

