/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.SuperBossesClass;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="superbosses")
public class LootTableBonusDrops {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity mob = event.getEntity();
        CompoundTag nbt = mob.getPersistentData();
        int bonusRolls = SuperBossesClass.getMobBonusRolls(mob);
        if (bonusRolls <= 0) {
            return;
        }
        LootTableBonusDrops.mobBonusRolls(mob, bonusRolls, event);
    }

    private static void mobBonusRolls(LivingEntity mob, int bonusRolls, LivingDeathEvent event) {
        Level level = mob.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(mob.getLootTable());
        for (int i = 0; i < bonusRolls; ++i) {
            LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)mob.level());
            lootParamsBuilder.withParameter(LootContextParams.THIS_ENTITY, (Object)mob);
            lootParamsBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)event.getSource());
            lootParamsBuilder.withParameter(LootContextParams.ORIGIN, (Object)mob.position());
            lootParamsBuilder.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)event.getSource().getEntity());
            LootParams lootParams = lootParamsBuilder.create(LootContextParamSets.ENTITY);
            lootTable.getRandomItems(lootParams).forEach(itemStack -> serverLevel.addFreshEntity((Entity)new ItemEntity(mob.level(), mob.getX(), mob.getY(), mob.getZ(), itemStack)));
        }
    }
}

