/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.SuperBossesClass;
import com.cheeseman.superbosses.config.CommonConfig;
import com.mojang.logging.LogUtils;
import java.util.LinkedHashMap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="superbosses")
public class SuperBosses {
    public static final String MODID = "superbosses";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String SUPER_BOSSES_NBT_KEY = "superbosses.boss_class_tracker_id";
    public static LinkedHashMap<String, SuperBossesClass> BossClasses = new LinkedHashMap();
    public static SuperBossesClass ultraMegaBoss;
    public static SuperBossesClass megaBoss;
    public static SuperBossesClass superDuperBoss;
    public static SuperBossesClass superBoss;

    public static void RegisterBossClass(SuperBossesClass bossClass) {
        LOGGER.info("Registered Boss Type of: " + bossClass.id);
        BossClasses.put(bossClass.id, bossClass);
    }

    public static void loadBossesFromConfig() {
        LOGGER.info("Loading Super Bosses From Config");
        ultraMegaBoss = SuperBossesClass.createSuperBossesClassFromConfig(CommonConfig.ultraMegaBossConfig);
        megaBoss = SuperBossesClass.createSuperBossesClassFromConfig(CommonConfig.megaBossConfig);
        superDuperBoss = SuperBossesClass.createSuperBossesClassFromConfig(CommonConfig.superDuperBossConfig);
        superBoss = SuperBossesClass.createSuperBossesClassFromConfig(CommonConfig.superBossConfig);
    }

    public SuperBosses(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SuperBosses.loadBossesFromConfig();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

