/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.BossAttributeOperator;
import com.cheeseman.superbosses.BossesAttributeModifier;
import com.cheeseman.superbosses.SuperBosses;
import com.cheeseman.superbosses.config.CommonConfig;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class SuperBossesClass {
    public String id;
    public float spawn_chance;
    public String name_prefix;
    public String name_suffix;
    public int bonus_loot_rolls;
    public BossesAttributeModifier[] attributeModifiers;

    public SuperBossesClass(String id, float spawn_chance, String name_prefix, String name_suffix, int bonus_loot_rolls, BossesAttributeModifier[] attributeModifiers) {
        this.id = id;
        this.spawn_chance = spawn_chance;
        this.name_prefix = name_prefix;
        this.name_suffix = name_suffix;
        this.bonus_loot_rolls = bonus_loot_rolls;
        this.attributeModifiers = attributeModifiers;
    }

    public static SuperBossesClass createSuperBossesClass(String id, float spawn_chance, String name_prefix, String name_suffix, int bonus_loot_rolls, BossesAttributeModifier[] attributeModifiers) {
        SuperBossesClass bossClass = new SuperBossesClass(id, spawn_chance, name_prefix, name_suffix, bonus_loot_rolls, attributeModifiers);
        SuperBosses.RegisterBossClass(bossClass);
        return bossClass;
    }

    public static SuperBossesClass createSuperBossesClassFromConfig(CommonConfig.BossConfig config) {
        return SuperBossesClass.createSuperBossesClass(config.iD, (float)config.spawnChance.getAsDouble(), (String)config.namePrefix.get(), "", config.bonusLootRolls.getAsInt(), new BossesAttributeModifier[]{new BossesAttributeModifier((Holder<Attribute>)Attributes.MAX_HEALTH, BossAttributeOperator.MULTIPLY, (float)config.healthMultiplier.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.MAX_HEALTH, BossAttributeOperator.ADD, (float)config.healthAdd.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, BossAttributeOperator.MULTIPLY, (float)config.attackMultiplier.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, BossAttributeOperator.MULTIPLY, (float)config.attackKnockbackMultiplier.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, BossAttributeOperator.MULTIPLY, (float)config.knockbackResistanceMultiplier.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, BossAttributeOperator.ADD, (float)config.knockbackResistanceAdd.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, BossAttributeOperator.MULTIPLY, (float)config.movementSpeed.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.FOLLOW_RANGE, BossAttributeOperator.MULTIPLY, (float)config.followRangeMultiplier.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.ARMOR, BossAttributeOperator.ADD, (float)config.armorAdd.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, BossAttributeOperator.ADD, (float)config.armorToughnessAdd.getAsDouble()), new BossesAttributeModifier((Holder<Attribute>)Attributes.SCALE, BossAttributeOperator.MULTIPLY, (float)config.scale.getAsDouble())});
    }

    public static int getMobBonusRolls(LivingEntity mob) {
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.contains("superbosses.boss_class_tracker_id")) {
            return 0;
        }
        ListTag trackersList = nbt.getList("superbosses.boss_class_tracker_id", 8);
        int bonusRolls = 0;
        for (int i = 0; i < trackersList.size(); ++i) {
            String trackerValue = trackersList.getString(i);
            if (!SuperBosses.BossClasses.containsKey(trackerValue)) continue;
            if (CommonConfig.doStackedBossLootDropsMultiply.getAsBoolean() && bonusRolls > 0) {
                bonusRolls *= SuperBosses.BossClasses.get((Object)trackerValue).bonus_loot_rolls;
                continue;
            }
            bonusRolls += SuperBosses.BossClasses.get((Object)trackerValue).bonus_loot_rolls;
        }
        return bonusRolls;
    }
}

