/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.Bossifier;
import com.cheeseman.superbosses.SuperBosses;
import com.cheeseman.superbosses.SuperBossesClass;
import com.cheeseman.superbosses.config.CommonConfig;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="superbosses")
public class SuperBossesSpawnEvent {
    public static final String NBT_KEY = "superbosses.types";

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide() || !(event.getEntity() instanceof Mob) || event.loadedFromDisk()) {
            return;
        }
        Mob mob = (Mob)event.getEntity();
        CompoundTag nbt = mob.getPersistentData();
        if (nbt.contains(NBT_KEY, 9)) {
            SuperBosses.LOGGER.info("Forced Boss Type Found");
            ListTag forcedBossTypesList = nbt.getList(NBT_KEY, 8);
            List<String> forcedBossTypesStringList = forcedBossTypesList.stream().map(Tag::getAsString).toList();
            for (Map.Entry<String, SuperBossesClass> entry : SuperBosses.BossClasses.entrySet()) {
                if (!forcedBossTypesStringList.contains(entry.getKey())) continue;
                SuperBosses.LOGGER.info("SPAWNING BOSS OF: " + entry.getValue().id);
                Bossifier.bossify(mob, entry.getValue());
            }
            nbt.remove(NBT_KEY);
            return;
        }
        if (!SuperBossesSpawnEvent.canMobBeSuperBoss((LivingEntity)mob)) {
            return;
        }
        for (Map.Entry<String, SuperBossesClass> entry : SuperBosses.BossClasses.entrySet()) {
            if ((double)new Random().nextFloat() >= (double)entry.getValue().spawn_chance * 0.01) continue;
            SuperBosses.LOGGER.info("SPAWNING BOSS OF: " + entry.getValue().id);
            Bossifier.bossify(mob, entry.getValue());
            if (CommonConfig.canBossesStack.getAsBoolean()) continue;
            break;
        }
    }

    private static boolean canMobBeSuperBoss(LivingEntity mob) {
        String mobId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType()).toString();
        return (!CommonConfig.onlyMonsterBosses.getAsBoolean() || mob instanceof Monster || ((List)CommonConfig.whitelist.get()).contains(mobId)) && !((List)CommonConfig.blacklist.get()).contains(mobId);
    }
}

