/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses.config;

import com.cheeseman.superbosses.SuperBosses;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="superbosses")
public class CommonConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final BossConfig superBossConfig = new BossConfig(BUILDER, "super_boss", "\u00a7e\u2b50\u00a7aSuper\u00a7e\u2b50\u00a7r ", 5.0, 2.5, 5.0, 1.6, 1.2, 1.15, 0.1, 1.1, 1.5, 4.0, 2.0, 1.0, 4);
    public static final BossConfig superDuperBossConfig = new BossConfig(BUILDER, "super_duper_boss", "\u00a7e\u2b50\u2b50\u00a79Super Duper\u00a7e\u2b50\u2b50\u00a7r ", 1.0, 3.5, 7.0, 2.8, 1.4, 1.5, 0.15, 1.2, 1.5, 8.0, 4.0, 1.15, 8);
    public static final BossConfig megaBossConfig = new BossConfig(BUILDER, "mega_boss", "\u00a7e\u2b50\u2b50\u2b50\u00a7c\u00a7lMega\u00a7e\u2b50\u2b50\u2b50\u00a7r ", 0.2, 5.5, 22.0, 6.5, 1.5, 2.0, 0.25, 1.3, 2.0, 15.0, 8.0, 1.3, 20);
    public static final BossConfig ultraMegaBossConfig = new BossConfig(BUILDER, "ultra_mega_boss", "\u00a7e\u2b50\u2b50\u2b50\u2b50\u00a76\u00a7lULTRA MEGA\u00a7e\u2b50\u2b50\u2b50\u2b50\u00a7r ", 0.05, 11.0, 55.0, 10.5, 3.5, 3.0, 0.45, 1.3, 3.0, 25.0, 16.0, 1.7, 60);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> hardcodedBosses = BUILDER.push("mob_settings").comment("Bosses that have hard-coded drops that don't use loot tables.\nFor these mobs we multiply the items dropped instead of re-rolling their loot table").defineListAllowEmpty("hardcodedBosses", List.of("minecraft:wither"), () -> "", CommonConfig::validateMobName);
    public static final ModConfigSpec.BooleanValue onlyMonsterBosses = BUILDER.comment("Should only mobs classified as 'Monsters' be able to spawn as Super Bosses\n(Note: if you turn this off you'll probably get some weird stuff becoming bosses)").define("onlyMonsterBosses", true);
    public static final ModConfigSpec.BooleanValue canBossesStack = BUILDER.comment("If a mob can roll more than one Boss type at the same time (EX. Super Ultra Mega Zombie)").define("canBossesStack", true);
    public static final ModConfigSpec.BooleanValue doStackedBossLootDropsMultiply = BUILDER.comment("If a mob has more than one Boss Type (EX. Super Super Duper Zombie)\n\nShould the bonus drops multiply [True] (4 x 8 = 32 Bonus Rolls)\n\nOr should they add [False] (4 + 8 = 12 Bonus Rolls)").define("doStackedBossLootDropsMultiply", true);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> whitelist = BUILDER.comment("Mobs that can spawn as Super Bosses even if they aren't categorized as a Monster").defineListAllowEmpty("whitelist", List.of(), () -> "", CommonConfig::validateMobName);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> blacklist = BUILDER.comment("Mobs that will never naturally spawn as a Super Boss").defineListAllowEmpty("blacklist", List.of(), () -> "", CommonConfig::validateMobName);
    public static final ModConfigSpec SPEC = BUILDER.build();

    @SubscribeEvent
    public static void ModConfigEvent(ModConfigEvent event) {
        SuperBosses.loadBossesFromConfig();
    }

    private static boolean validateMobName(Object obj) {
        String mobName;
        return obj instanceof String && (mobName = (String)obj).contains(":");
    }

    public static class BossConfig {
        public final String iD;
        public final ModConfigSpec.ConfigValue<String> namePrefix;
        public final ModConfigSpec.DoubleValue spawnChance;
        public final ModConfigSpec.DoubleValue healthMultiplier;
        public final ModConfigSpec.DoubleValue healthAdd;
        public final ModConfigSpec.DoubleValue attackMultiplier;
        public final ModConfigSpec.DoubleValue attackKnockbackMultiplier;
        public final ModConfigSpec.DoubleValue knockbackResistanceMultiplier;
        public final ModConfigSpec.DoubleValue knockbackResistanceAdd;
        public final ModConfigSpec.DoubleValue movementSpeed;
        public final ModConfigSpec.DoubleValue followRangeMultiplier;
        public final ModConfigSpec.DoubleValue armorAdd;
        public final ModConfigSpec.DoubleValue armorToughnessAdd;
        public final ModConfigSpec.DoubleValue scale;
        public final ModConfigSpec.IntValue bonusLootRolls;

        public BossConfig(ModConfigSpec.Builder builder, String bossID, String namePrefixDefault, double spawnChanceDefault, double healthMultiplierDefault, double healthAddDefault, double attackMultiplierDefault, double attackKnockbackDefault, double knockbackResistanceMultiplierDefault, double KnockbackResistanceAddDefault, double movementSpeedDefault, double followRangeMultiplierDefault, double armorAddDefault, double armorToughnessAddDefault, double scaleDefault, int bonusLootRollsDefault) {
            this.iD = bossID;
            builder.push(bossID + "_settings");
            this.spawnChance = builder.defineInRange("spawnChance", spawnChanceDefault, 0.0, 100.0);
            this.namePrefix = builder.define("namePrefix", (Object)namePrefixDefault);
            this.healthMultiplier = builder.defineInRange("healthMultiplier", healthMultiplierDefault, 0.0, 100000.0);
            this.healthAdd = builder.defineInRange("healthAdd", healthAddDefault, 0.0, 100000.0);
            this.attackMultiplier = builder.defineInRange("attackMultiplier", attackMultiplierDefault, 0.0, 100000.0);
            this.attackKnockbackMultiplier = builder.defineInRange("attackKnockbackMultiplier", attackKnockbackDefault, 0.0, 100000.0);
            this.knockbackResistanceMultiplier = builder.defineInRange("knockbackResistanceMultiplier", knockbackResistanceMultiplierDefault, 0.0, 100000.0);
            this.knockbackResistanceAdd = builder.defineInRange("knockbackResistanceAdd", KnockbackResistanceAddDefault, 0.0, 100000.0);
            this.movementSpeed = builder.defineInRange("movementSpeed", movementSpeedDefault, 0.0, 100000.0);
            this.followRangeMultiplier = builder.defineInRange("followRangeMultiplier", followRangeMultiplierDefault, 0.0, 100000.0);
            this.armorAdd = builder.defineInRange("armorAdd", armorAddDefault, 0.0, 100000.0);
            this.armorToughnessAdd = builder.defineInRange("armorToughnessAdd", armorToughnessAddDefault, 0.0, 100000.0);
            this.scale = builder.defineInRange("scale", scaleDefault, 0.0, 100000.0);
            this.bonusLootRolls = builder.defineInRange("bonusLootRolls", bonusLootRollsDefault, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

