/*
 * Decompiled with CFR 0.152.
 */
package Periklis20M.opLogin;

import Periklis20M.opLogin.OpLoginCommand;
import Periklis20M.opLogin.OpReloadCommand;
import Periklis20M.opLogin.OpSetPassCommand;
import Periklis20M.opLogin.PasswordManager;
import Periklis20M.opLogin.ResetOpCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class OpLogin
extends JavaPlugin
implements Listener {
    private PasswordManager passwordManager;

    public void onEnable() {
        this.passwordManager = new PasswordManager(this);
        this.getCommand("opsetpass").setExecutor((CommandExecutor)new OpSetPassCommand(this.passwordManager));
        this.getCommand("oplogin").setExecutor((CommandExecutor)new OpLoginCommand(this.passwordManager, this.getConfig()));
        this.getCommand("resetop").setExecutor((CommandExecutor)new ResetOpCommand(this.passwordManager));
        this.getCommand("opreload").setExecutor((CommandExecutor)new OpReloadCommand(this, this.passwordManager));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        if (this.passwordManager != null) {
            this.passwordManager.shutdown();
            this.passwordManager = null;
        }
        System.gc();
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.saveDefaultConfig();
    }

    public void performReload() {
        try {
            this.reloadConfig();
            if (this.passwordManager != null) {
                this.passwordManager.reloadAll();
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Error during reload: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() && !this.passwordManager.isCommandWhitelisted(event.getMessage()) && !this.passwordManager.isLoggedIn(player.getName())) {
            event.setCancelled(true);
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getConfig().getString("messages.prefix") + this.getConfig().getString("messages.must-login")));
            player.sendMessage(message);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.passwordManager.logoutPlayer(event.getPlayer().getName());
    }
}

