/*
 * Decompiled with CFR 0.152.
 */
package Periklis20M.opLogin;

import Periklis20M.opLogin.PasswordManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class OpLoginCommand
implements CommandExecutor {
    private final PasswordManager passwordManager;
    private final FileConfiguration config;

    public OpLoginCommand(PasswordManager passwordManager, FileConfiguration config) {
        this.passwordManager = passwordManager;
        this.config = config;
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.colorize(this.config.getString("messages.player-only")));
            return false;
        }
        Player player = (Player)sender;
        if (!player.isOp()) {
            player.sendMessage(this.colorize(this.config.getString("messages.op-only")));
            return false;
        }
        if (args.length != 1) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + "\u00a7cUsage: /oplogin <password>"));
            return false;
        }
        if (this.passwordManager.isLoggedIn(player.getName())) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.already-logged")));
            return false;
        }
        String playerName = player.getName();
        if (this.passwordManager.isPlayerBlocked(playerName)) {
            long minutes = this.passwordManager.getBlockTimeRemaining(playerName);
            String message = this.config.getString("messages.too-many-attempts").replace("%minutes%", String.valueOf(minutes));
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + message));
            return false;
        }
        if (!this.passwordManager.hasPassword(playerName)) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-password")));
            return false;
        }
        if (this.passwordManager.checkPassword(playerName, args[0])) {
            this.passwordManager.loginPlayer(playerName);
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.login-success")));
            return true;
        }
        player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.login-failed")));
        return false;
    }
}

