/*
 * Decompiled with CFR 0.152.
 */
package Periklis20M.opLogin;

import Periklis20M.opLogin.utils.EncryptionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PasswordManager {
    private final JavaPlugin plugin;
    private final Map<String, String> passwords = new HashMap<String, String>();
    private final Set<String> loggedInPlayers = new HashSet<String>();
    private final Set<String> whitelistedCommands = new HashSet<String>();
    private final Map<String, Integer> failedAttempts = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Instant> blockTimes = new ConcurrentHashMap<String, Instant>();
    private EncryptionUtil encryptionUtil;
    private File configFile;
    private File whitelistFile;
    private FileConfiguration config;
    private FileConfiguration whitelist;

    public PasswordManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupFiles();
        this.ensureDefaultValues();
        this.loadPasswords();
        this.loadWhitelist();
        this.initializeEncryption();
    }

    private void setupFiles() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.config = new YamlConfiguration();
        if (!this.configFile.exists()) {
            try {
                this.plugin.saveResource("config.yml", false);
                this.config.load(this.configFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not create default config.yml");
            }
        } else {
            try {
                this.config.load(this.configFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load config.yml");
            }
        }
        this.whitelistFile = new File(this.plugin.getDataFolder(), "whitelist.yml");
        this.whitelist = new YamlConfiguration();
        if (!this.whitelistFile.exists()) {
            try {
                this.plugin.saveResource("whitelist.yml", false);
                this.whitelist.load(this.whitelistFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not create default whitelist.yml");
            }
        } else {
            try {
                this.whitelist.load(this.whitelistFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load whitelist.yml");
            }
        }
    }

    private void ensureDefaultValues() {
        boolean needsSave = false;
        if (!this.config.contains("security")) {
            needsSave = true;
            this.config.createSection("security");
            this.config.set("security.min-password-length", (Object)8);
            this.config.set("security.max-login-attempts", (Object)3);
            this.config.set("security.block-duration", (Object)15);
        }
        if (!this.config.contains("messages")) {
            needsSave = true;
            this.config.createSection("messages");
            this.config.set("messages.prefix", (Object)"&8[&bOpLogin&8] &7");
            this.config.set("messages.login-success", (Object)"&aLogin successful! You can now use OP commands.");
            this.config.set("messages.login-failed", (Object)"&cIncorrect password.");
            this.config.set("messages.already-logged", (Object)"&cYou are already logged in!");
            this.config.set("messages.no-password", (Object)"&cYou don't have a password set. Ask an administrator to set one for you.");
            this.config.set("messages.console-only", (Object)"&cThis command can only be executed from the console.");
            this.config.set("messages.player-only", (Object)"&cThis command can only be used by players.");
            this.config.set("messages.op-only", (Object)"&cThis command is only for server operators.");
            this.config.set("messages.must-login", (Object)"&cYou must login first using /oplogin <password>");
            this.config.set("messages.password-set", (Object)"&aPassword set for %player%");
            this.config.set("messages.password-reset", (Object)"&aPassword reset for %player%");
            this.config.set("messages.config-reloaded", (Object)"&aOpLogin configuration and whitelist reloaded successfully!");
            this.config.set("messages.too-short-password", (Object)"&cPassword must be at least %length% characters long.");
            this.config.set("messages.too-many-attempts", (Object)"&cToo many failed attempts. Please try again in %minutes% minutes.");
        }
        if (needsSave) {
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save default config values");
            }
        }
    }

    public void loadWhitelist() {
        this.whitelistedCommands.clear();
        List commands = this.whitelist.getStringList("whitelisted-commands");
        this.whitelistedCommands.addAll(commands.stream().map(String::toLowerCase).toList());
    }

    public boolean isCommandWhitelisted(String command) {
        String cleanCommand = command.startsWith("/") ? command.substring(1).toLowerCase() : command.toLowerCase();
        String baseCommand = cleanCommand.split(" ")[0];
        return this.whitelistedCommands.contains(baseCommand);
    }

    private void initializeEncryption() {
        String existingKey = this.config.getString("security.encryption-key", "");
        this.encryptionUtil = new EncryptionUtil(existingKey);
        if (existingKey.isEmpty()) {
            this.config.set("security.encryption-key", (Object)this.encryptionUtil.getEncodedKey());
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save encryption key!");
            }
        }
    }

    public void loadPasswords() {
        this.passwords.clear();
        if (this.config.contains("passwords")) {
            for (String player : this.config.getConfigurationSection("passwords").getKeys(false)) {
                String encrypted = this.config.getString("passwords." + player);
                this.passwords.put(player.toLowerCase(), encrypted);
            }
        }
    }

    public void savePasswords() {
        this.config.set("passwords", null);
        for (Map.Entry<String, String> entry : this.passwords.entrySet()) {
            this.config.set("passwords." + entry.getKey(), (Object)entry.getValue());
        }
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save passwords to config.yml");
        }
    }

    public boolean setPassword(String player, String password) {
        if (password.length() < this.config.getInt("security.min-password-length", 8)) {
            return false;
        }
        String encrypted = this.encryptionUtil.encrypt(password);
        this.passwords.put(player.toLowerCase(), encrypted);
        this.savePasswords();
        return true;
    }

    public boolean checkPassword(String player, String password) {
        String playerKey = player.toLowerCase();
        String encrypted = this.passwords.get(playerKey);
        if (encrypted == null) {
            return false;
        }
        if (this.isPlayerBlocked(playerKey)) {
            return false;
        }
        boolean matches = this.encryptionUtil.decrypt(encrypted).equals(password);
        if (!matches) {
            this.recordFailedAttempt(playerKey);
        } else {
            this.resetFailedAttempts(playerKey);
        }
        return matches;
    }

    private void recordFailedAttempt(String player) {
        int attempts = this.failedAttempts.getOrDefault(player, 0) + 1;
        this.failedAttempts.put(player, attempts);
        if (attempts >= this.config.getInt("security.max-login-attempts", 3)) {
            this.blockTimes.put(player, Instant.now().plusSeconds((long)this.config.getInt("security.block-duration", 15) * 60L));
        }
    }

    private void resetFailedAttempts(String player) {
        this.failedAttempts.remove(player);
        this.blockTimes.remove(player);
    }

    public boolean isPlayerBlocked(String player) {
        Instant blockUntil = this.blockTimes.get(player);
        if (blockUntil != null) {
            if (Instant.now().isBefore(blockUntil)) {
                return true;
            }
            this.blockTimes.remove(player);
            this.failedAttempts.remove(player);
        }
        return false;
    }

    public long getBlockTimeRemaining(String player) {
        Instant blockUntil = this.blockTimes.get(player);
        if (blockUntil != null && Instant.now().isBefore(blockUntil)) {
            return (blockUntil.getEpochSecond() - Instant.now().getEpochSecond()) / 60L;
        }
        return 0L;
    }

    public boolean resetPassword(String player) {
        boolean result;
        boolean bl = result = this.passwords.remove(player.toLowerCase()) != null;
        if (result) {
            this.savePasswords();
        }
        return result;
    }

    public void loginPlayer(String player) {
        this.loggedInPlayers.add(player.toLowerCase());
    }

    public void logoutPlayer(String player) {
        this.loggedInPlayers.remove(player.toLowerCase());
    }

    public boolean isLoggedIn(String player) {
        return this.loggedInPlayers.contains(player.toLowerCase());
    }

    public boolean hasPassword(String player) {
        return this.passwords.containsKey(player.toLowerCase());
    }

    public void shutdown() {
        this.savePasswords();
        this.passwords.clear();
        this.loggedInPlayers.clear();
        this.whitelistedCommands.clear();
        this.failedAttempts.clear();
        this.blockTimes.clear();
        this.config = null;
        this.whitelist = null;
        this.configFile = null;
        this.whitelistFile = null;
        this.encryptionUtil = null;
    }

    private void backupAndRestoreConfig() {
        try {
            File configBackup = new File(this.plugin.getDataFolder(), "config.yml.backup");
            File whitelistBackup = new File(this.plugin.getDataFolder(), "whitelist.yml.backup");
            if (this.configFile.exists()) {
                Files.copy(this.configFile.toPath(), configBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (this.whitelistFile.exists()) {
                Files.copy(this.whitelistFile.toPath(), whitelistBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.plugin.reloadConfig();
            if (configBackup.exists()) {
                Files.copy(configBackup.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (whitelistBackup.exists()) {
                Files.copy(whitelistBackup.toPath(), this.whitelistFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            configBackup.delete();
            whitelistBackup.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error during config backup/restore: " + e.getMessage());
        }
    }

    public void reloadAll() {
        try {
            if (this.configFile != null && this.configFile.exists()) {
                this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            }
            if (this.whitelistFile != null && this.whitelistFile.exists()) {
                this.whitelist = YamlConfiguration.loadConfiguration((File)this.whitelistFile);
            }
            this.initializeEncryption();
            this.loadPasswords();
            this.loadWhitelist();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during reload: " + e.getMessage());
        }
    }
}

