/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns;

import java.util.Optional;
import java.util.function.Predicate;
import mod.traister101.sns.common.attribute.SNSAttributes;
import mod.traister101.sns.common.items.SNSItems;
import mod.traister101.sns.util.handlers.PickupHandler;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ForgeEventHandler {
    public static void init() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register(ForgeEventHandler.class);
        eventBus.addListener(PickupHandler::onPickupItem);
        eventBus.addListener(EventPriority.LOWEST, PickupHandler::onGroundBlockInteract);
    }

    @SubscribeEvent
    public static void onProjectilePrepare(LivingGetProjectileEvent event) {
        Item item = event.getProjectileWeaponItemStack().m_41720_();
        if (!(item instanceof ProjectileWeaponItem)) {
            return;
        }
        ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)item;
        Predicate supportedProjectile = projectileWeaponItem.m_6437_();
        ItemStack projectileItemStack = event.getProjectileItemStack();
        if (!projectileItemStack.m_41619_()) {
            return;
        }
        event.getEntity().getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().flatMap(entityInventory -> {
            for (int entitySlot = 0; entitySlot < entityInventory.getSlots(); ++entitySlot) {
                ItemStack stackInSlot = entityInventory.getStackInSlot(entitySlot);
                if (!stackInSlot.m_150930_((Item)SNSItems.QUIVER.get())) continue;
                return stackInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().map(itemHandler -> {
                    for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
                        ItemStack ammoStack = itemHandler.getStackInSlot(slotIndex);
                        if (!supportedProjectile.test(ammoStack)) continue;
                        return ammoStack;
                    }
                    return ItemStack.f_41583_;
                });
            }
            return Optional.empty();
        }).ifPresent(arg_0 -> ((LivingGetProjectileEvent)event).setProjectileItemStack(arg_0));
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        AttributeInstance attribute = event.getEntity().m_21051_((Attribute)SNSAttributes.EXTRA_FALL_DISTANCE.get());
        if (attribute == null) {
            return;
        }
        event.setDistance((float)Math.max(0.0, (double)event.getDistance() - attribute.m_22135_()));
    }

    private ForgeEventHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

