/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.client;

import mod.traister101.sns.client.SNSKeybinds;
import mod.traister101.sns.common.capability.ILunchboxHandler;
import mod.traister101.sns.common.capability.SNSCapabilities;
import mod.traister101.sns.common.items.SNSItems;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.mixins.client.invoker.AddCustomNbtDataInvoker;
import mod.traister101.sns.network.SNSPacketHandler;
import mod.traister101.sns.network.ServerboundOpenContainerPacket;
import mod.traister101.sns.network.ServerboundPacketCycleSlotPacket;
import mod.traister101.sns.util.NBTHelper;
import mod.traister101.sns.util.SNSUtils;
import mod.traister101.sns.util.handlers.PickBlockHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;

public final class ClientForgeEventHandler {
    public static final Minecraft MC = Minecraft.m_91087_();

    public static void init() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientForgeEventHandler::onKeyPress);
        eventBus.addListener(ClientForgeEventHandler::onClickInput);
        eventBus.addListener(ClientForgeEventHandler::onMouseScroll);
    }

    public static void onKeyPress(InputEvent.Key event) {
        if (ClientForgeEventHandler.MC.f_91074_ == null) {
            return;
        }
        if (SNSKeybinds.OPEN_ITEM_CONTAINER.m_90859_()) {
            SNSPacketHandler.sendToServer(new ServerboundOpenContainerPacket());
        }
        if (SNSKeybinds.TOGGLE_PICKUP.m_90857_()) {
            ItemStack heldStack = ClientForgeEventHandler.MC.f_91074_.m_21205_();
            boolean flag = !NBTHelper.isAutoPickup(heldStack);
            SNSUtils.sendTogglePacket(SNSUtils.ToggleType.PICKUP, flag);
            ClientForgeEventHandler.MC.f_91074_.m_5661_((Component)SNSUtils.ToggleType.PICKUP.getTooltip(flag), true);
        }
    }

    private static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (!event.isPickBlock()) {
            return;
        }
        if (((Boolean)SNSConfig.COMMON.doPickBlock.get()).booleanValue()) {
            if (ClientForgeEventHandler.MC.f_91074_ == null) {
                return;
            }
            if (ClientForgeEventHandler.MC.f_91077_ == null) {
                return;
            }
            if (ClientForgeEventHandler.MC.f_91074_.m_7500_()) {
                return;
            }
            event.setCanceled(ClientForgeEventHandler.vanillaPickBlock(ClientForgeEventHandler.MC.f_91077_, (Player)ClientForgeEventHandler.MC.f_91074_, (Level)ClientForgeEventHandler.MC.f_91073_, ClientForgeEventHandler.MC.f_91072_) || PickBlockHandler.onPickBlock((Player)ClientForgeEventHandler.MC.f_91074_, ClientForgeEventHandler.MC.f_91077_));
        }
    }

    private static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (ClientForgeEventHandler.MC.f_91074_ == null) {
            return;
        }
        ItemStack mainHandStack = ClientForgeEventHandler.MC.f_91074_.m_21205_();
        if (!mainHandStack.m_150930_((Item)SNSItems.LUNCHBOX.get())) {
            return;
        }
        if (!ClientForgeEventHandler.MC.f_91074_.m_6144_()) {
            return;
        }
        double scrollDelta = event.getScrollDelta();
        boolean scrollForwards = scrollDelta < 0.0;
        boolean scrollBackwards = scrollDelta > 0.0;
        LazyOptional capability = mainHandStack.getCapability(SNSCapabilities.LUNCHBOX);
        if (scrollForwards) {
            capability.ifPresent(lunchboxHandler -> lunchboxHandler.cycleSelected(ILunchboxHandler.CycleDirection.FORWARD));
            SNSPacketHandler.sendToServer(new ServerboundPacketCycleSlotPacket(ILunchboxHandler.CycleDirection.FORWARD));
        } else if (scrollBackwards) {
            capability.ifPresent(lunchboxHandler -> lunchboxHandler.cycleSelected(ILunchboxHandler.CycleDirection.BACKWARD));
            SNSPacketHandler.sendToServer(new ServerboundPacketCycleSlotPacket(ILunchboxHandler.CycleDirection.BACKWARD));
        }
        event.setCanceled(true);
    }

    public static boolean vanillaPickBlock(HitResult hitResult, Player player, Level level, MultiPlayerGameMode gameMode) {
        boolean creative = player.m_150110_().f_35937_;
        ItemStack pickedStack = ClientForgeEventHandler.getPickedStack(player, level, hitResult, creative);
        if (pickedStack.m_41619_()) {
            return false;
        }
        Inventory inventory = player.m_150109_();
        if (creative) {
            inventory.m_36012_(pickedStack);
            gameMode.m_105241_(player.m_21120_(InteractionHand.MAIN_HAND), 36 + inventory.f_35977_);
            return true;
        }
        int slotIndex = inventory.m_36030_(pickedStack);
        if (slotIndex != -1) {
            if (Inventory.m_36045_((int)slotIndex)) {
                inventory.f_35977_ = slotIndex;
            } else {
                gameMode.m_105206_(slotIndex);
            }
            return true;
        }
        return false;
    }

    private static ItemStack getPickedStack(Player player, Level level, HitResult hitResult, boolean creative) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            BlockEntity blockEntity;
            BlockPos blockpos = ((BlockHitResult)hitResult).m_82425_();
            BlockState blockState = level.m_8055_(blockpos);
            if (blockState.m_60795_()) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = blockState.getCloneItemStack(hitResult, (BlockGetter)level, blockpos, player);
            if (creative && Screen.m_96637_() && blockState.m_155947_() && (blockEntity = level.m_7702_(blockpos)) != null) {
                ((AddCustomNbtDataInvoker)MC).invokeAddCustomNbtData(itemStack, blockEntity);
            }
            return itemStack;
        }
        if (type != HitResult.Type.ENTITY || !creative) {
            return ItemStack.f_41583_;
        }
        Entity entity = ((EntityHitResult)hitResult).m_82443_();
        return entity.getPickedResult(hitResult);
    }
}

