/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.traister101.sns.common.capability.SNSCapabilities;
import mod.traister101.sns.common.items.SNSItems;
import mod.traister101.sns.util.SNSUtils;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public enum SacksNSuchGuiOverlay {
    LUNCHBOX_INFO("lunchbox_info", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        ItemStack currentItem;
        LocalPlayer player;
        Minecraft minecraft = gui.getMinecraft();
        if (!minecraft.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
        }
        if ((player = minecraft.f_91074_) == null) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_150930_((Item)SNSItems.LUNCHBOX.get())) {
            ItemStack offhandItem = player.m_21206_();
            if (!offhandItem.m_150930_((Item)SNSItems.LUNCHBOX.get())) {
                return;
            }
            currentItem = offhandItem;
        } else {
            currentItem = mainHandItem;
        }
        currentItem.getCapability(SNSCapabilities.LUNCHBOX).ifPresent(lunchboxHandler -> {
            int nextLineOfText = SacksNSuchGuiOverlay.renderComponent(minecraft.f_91062_, guiGraphics, (Component)Component.m_237110_((String)"sns.tooltip.lunchbox.selected_slot", (Object[])new Object[]{SNSUtils.intComponent(lunchboxHandler.getSelectedSlot() + 1)}), screenWidth, screenHeight);
            ItemStack selectedStack = lunchboxHandler.getSelectedStack();
            nextLineOfText = SacksNSuchGuiOverlay.renderFormatedText(minecraft.f_91062_, guiGraphics, minecraft.f_91062_.m_92923_((FormattedText)selectedStack.m_41786_(), screenWidth / 4), screenWidth, nextLineOfText);
            int itemStackX = screenWidth - 16;
            int itemStackY = nextLineOfText - 16;
            guiGraphics.m_280480_(selectedStack, itemStackX, itemStackY);
            guiGraphics.m_280370_(minecraft.f_91062_, selectedStack, itemStackX, itemStackY);
            nextLineOfText -= 12;
            if (selectedStack.m_41619_()) {
                return;
            }
            if (!player.m_6144_()) {
                return;
            }
            Optional maybeComponents = selectedStack.getCapability(FoodCapability.CAPABILITY).map(iFood -> {
                ArrayList<MutableComponent> foodTooltip = new ArrayList<MutableComponent>();
                FoodData data = iFood.getData();
                foodTooltip.add(Component.m_237115_((String)"tfc.tooltip.nutrition").m_130940_(ChatFormatting.GRAY));
                boolean hasData = false;
                if (!iFood.isRotten()) {
                    int water;
                    float saturation = data.saturation();
                    if (0.0f < saturation) {
                        foodTooltip.add(Component.m_237110_((String)"tfc.tooltip.nutrition_saturation", (Object[])new Object[]{String.format("%d", (int)(saturation * 5.0f))}).m_130940_(ChatFormatting.GRAY));
                        hasData = true;
                    }
                    if (0 < (water = (int)data.water())) {
                        foodTooltip.add(Component.m_237110_((String)"tfc.tooltip.nutrition_water", (Object[])new Object[]{String.format("%d", water)}).m_130940_(ChatFormatting.GRAY));
                        hasData = true;
                    }
                    for (Nutrient nutrient : Nutrient.VALUES) {
                        float value = data.nutrient(nutrient);
                        if (0.0f >= value) continue;
                        foodTooltip.add(Component.m_237113_((String)" - ").m_7220_((Component)Helpers.translateEnum((Enum)nutrient)).m_130946_(": " + String.format("%.1f", Float.valueOf(value))).m_130940_(nutrient.getColor()));
                        hasData = true;
                    }
                }
                if (!hasData) {
                    foodTooltip.add(Component.m_237115_((String)"tfc.tooltip.nutrition_none").m_130940_(ChatFormatting.GRAY));
                }
                return foodTooltip;
            });
            if (maybeComponents.isEmpty()) {
                return;
            }
            SacksNSuchGuiOverlay.renderComponents(minecraft.f_91062_, guiGraphics, (List)maybeComponents.get(), screenWidth, nextLineOfText);
        });
    });

    private final String id;
    private final IGuiOverlay overlay;

    private SacksNSuchGuiOverlay(String id, IGuiOverlay overlay) {
        this.id = id;
        this.overlay = overlay;
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), LUNCHBOX_INFO.id(), SacksNSuchGuiOverlay.LUNCHBOX_INFO.overlay);
    }

    private static int renderComponent(Font font, GuiGraphics guiGraphics, Component component, int xPos, int startY) {
        return SacksNSuchGuiOverlay.renderComponentsInternal(font, guiGraphics, List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)component.m_7532_())), xPos, startY);
    }

    private static int renderComponents(Font font, GuiGraphics guiGraphics, List<Component> components, int xPos, int startY) {
        return SacksNSuchGuiOverlay.renderComponentsInternal(font, guiGraphics, components.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList(), xPos, startY);
    }

    private static int renderFormatedText(Font font, GuiGraphics guiGraphics, List<FormattedCharSequence> text, int xPos, int startY) {
        return SacksNSuchGuiOverlay.renderComponentsInternal(font, guiGraphics, text.stream().map(ClientTooltipComponent::m_169948_).toList(), xPos, startY);
    }

    private static int renderComponentsInternal(Font font, GuiGraphics guiGraphics, List<ClientTooltipComponent> clientTooltipComponents, int xPos, int startY) {
        int top;
        int textHeight = top = startY - clientTooltipComponents.stream().mapToInt(ClientTooltipComponent::m_142103_).sum();
        for (ClientTooltipComponent component : clientTooltipComponents) {
            component.m_142440_(font, xPos - component.m_142069_(font), textHeight, guiGraphics.m_280168_().m_85850_().m_252922_(), guiGraphics.m_280091_());
            textHeight += component.m_142103_() + (textHeight == 0 ? 2 : 0);
        }
        return top;
    }

    public String id() {
        return this.id;
    }
}

