/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.client.renderer.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import mod.traister101.sns.client.models.LargeSackModel;
import mod.traister101.sns.client.models.SmallSackModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public final class HipCurioRenderer<M extends Model>
implements ICurioRenderer {
    public static final ResourceLocation LEATHER_SACK_TEXTURE = new ResourceLocation("sns", "textures/curios/leather_sack.png");
    public static final ResourceLocation BURLAP_SACK_TEXTURE = new ResourceLocation("sns", "textures/curios/burlap_sack.png");
    public static final ResourceLocation SEED_POUCH_TEXTURE = new ResourceLocation("sns", "textures/curios/seed_pouch.png");
    public static final ResourceLocation ORE_SACK_TEXTURE = new ResourceLocation("sns", "textures/curios/ore_sack.png");
    private final ResourceLocation texture;
    private final M model;
    @Nullable
    private final ModelAnimator<M> modelAnimator;

    private HipCurioRenderer(ResourceLocation texture, M model, @Nullable ModelAnimator<M> modelAnimator) {
        this.texture = texture;
        this.model = model;
        this.modelAnimator = modelAnimator;
    }

    private static ModelPart bakeLayer(ModelLayerLocation layerLocation) {
        EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
        return entityModels.m_171103_(layerLocation);
    }

    public static <M extends Model> CurioRendererFactory factory(ModelFactory<M> modelFactory, ModelLayerLocation layerLocation, @Nullable ModelAnimator<M> setupAnim) {
        return texture -> new HipCurioRenderer(texture, modelFactory.create(HipCurioRenderer.bakeLayer(layerLocation)), setupAnim);
    }

    public static CurioRendererFactory largeSackFactory() {
        return HipCurioRenderer.factory(LargeSackModel::new, LargeSackModel.LAYER_LOCATION, LargeSackModel::setupAnim);
    }

    public static CurioRendererFactory smallSackFactory() {
        return HipCurioRenderer.factory(SmallSackModel::new, SmallSackModel.LAYER_LOCATION, SmallSackModel::setupAnim);
    }

    public <E extends LivingEntity, EM extends EntityModel<E>> void render(ItemStack itemStack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<E, EM> renderLayerParent, MultiBufferSource bufferSource, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (itemStack.m_41619_()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(slotContext.index() % 2 == 1 ? -90.0f : 90.0f));
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        poseStack.m_85837_(0.0, -0.15, 0.8);
        if (entity.m_6047_()) {
            poseStack.m_85837_(-0.35, 0.1875, 0.0);
        }
        if (this.modelAnimator != null) {
            this.modelAnimator.animate(this.model, limbSwing, limbSwingAmount);
        }
        this.model.m_7695_(poseStack, bufferSource.m_6299_(this.model.m_103119_(this.texture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @FunctionalInterface
    public static interface ModelAnimator<M extends Model> {
        public void animate(M var1, float var2, float var3);
    }

    @FunctionalInterface
    public static interface ModelFactory<M extends Model> {
        public M create(ModelPart var1);
    }

    @FunctionalInterface
    public static interface CurioRendererFactory {
        public ICurioRenderer create(ResourceLocation var1);

        default public CurioRendererSupplierFactory supplier() {
            return texture -> () -> this.create(texture);
        }

        @FunctionalInterface
        public static interface CurioRendererSupplierFactory {
            public Supplier<ICurioRenderer> create(ResourceLocation var1);
        }
    }
}

