/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.capability;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntConsumer;
import mod.traister101.esc.common.capability.ExtendedSlotCapacityHandler;
import mod.traister101.sns.common.SNSItemTags;
import mod.traister101.sns.common.capability.IVoidingItemHandler;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.util.ContainerType;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ContainerItemHandler
extends ExtendedSlotCapacityHandler
implements IVoidingItemHandler {
    public final ContainerType type;
    protected final ItemStack handlerStack;
    private final Set<Integer> voidSlots = new HashSet<Integer>();
    @Nullable
    private Weight cachedWeight;

    public ContainerItemHandler(ContainerType type, ItemStack handlerStack) {
        super(type.getSlotCount(), type.getSlotCapacity());
        this.type = type;
        this.handlerStack = handlerStack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = super.serializeNBT();
        compoundTag.m_128344_("weight", (byte)(this.cachedWeight != null ? this.cachedWeight.ordinal() : -1));
        compoundTag.m_128385_("voidSlots", this.voidSlots.stream().mapToInt(Integer::intValue).toArray());
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        super.deserializeNBT(compoundTag);
        byte weight = compoundTag.m_128445_("weight");
        if (weight != -1) {
            this.cachedWeight = Weight.valueOf((int)weight);
        }
        this.voidSlots.clear();
        this.voidSlots.addAll(Arrays.stream(compoundTag.m_128465_("voidSlots")).boxed().toList());
    }

    public ItemStack insertItem(int slotIndex, ItemStack insertStack, boolean simulate) {
        ItemStack remainder = super.insertItem(slotIndex, insertStack, simulate);
        if (remainder.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!((Boolean)SNSConfig.SERVER.doVoiding.get()).booleanValue()) {
            return remainder;
        }
        if (!this.type.doesVoiding()) {
            return remainder;
        }
        if (this.voidSlots.contains(slotIndex) && ItemHandlerHelper.canItemStacksStack((ItemStack)insertStack, (ItemStack)this.getStackInSlot(slotIndex))) {
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    public boolean isItemValid(int slotIndex, ItemStack itemStack) {
        if (itemStack.m_204117_(SNSItemTags.PREVENTED_IN_ITEM_CONTAINERS)) {
            return false;
        }
        return this.fitsInSlot(itemStack);
    }

    protected void onContentsChanged(int slotIndex) {
        this.cachedWeight = null;
        super.onContentsChanged(slotIndex);
    }

    protected final boolean fitsInSlot(ItemStack itemStack) {
        IItemSize stackSize = ItemSizeManager.get((ItemStack)itemStack);
        Size size = stackSize.getSize(itemStack);
        return size.isEqualOrSmallerThan(this.type.getAllowedSize());
    }

    public Weight getWeight() {
        if (this.cachedWeight != null) {
            return this.cachedWeight;
        }
        int totalItems = 0;
        int maxCapacity = 0;
        for (int slotIndex = 0; slotIndex < this.getSlots(); ++slotIndex) {
            ItemStack itemStack = (ItemStack)this.stacks.get(slotIndex);
            totalItems += itemStack.m_41613_();
            maxCapacity += this.getStackLimit(slotIndex, itemStack);
        }
        float amountFilled = (float)totalItems / (float)maxCapacity;
        if (0.8 <= (double)amountFilled) {
            this.cachedWeight = Weight.VERY_HEAVY;
            return this.cachedWeight;
        }
        if (0.6 <= (double)amountFilled) {
            this.cachedWeight = Weight.HEAVY;
            return this.cachedWeight;
        }
        if (0.4 <= (double)amountFilled) {
            this.cachedWeight = Weight.MEDIUM;
            return this.cachedWeight;
        }
        if (0.2 <= (double)amountFilled) {
            this.cachedWeight = Weight.LIGHT;
            return this.cachedWeight;
        }
        this.cachedWeight = Weight.VERY_LIGHT;
        return this.cachedWeight;
    }

    @Override
    public void forEachVoidSlot(IntConsumer consumer) {
        this.voidSlots.forEach(consumer::accept);
    }

    @Override
    public boolean isVoidingEnabled() {
        return !this.voidSlots.isEmpty();
    }

    @Override
    public void toggleVoidSlot(int slotIndex) {
        if (!this.type.doesVoiding()) {
            return;
        }
        if (this.voidSlots.contains(slotIndex)) {
            this.voidSlots.remove(slotIndex);
        } else {
            this.voidSlots.add(slotIndex);
        }
    }
}

