/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mod.traister101.sns.common.capability.ContainerItemHandler;
import mod.traister101.sns.common.capability.IVoidingItemHandler;
import mod.traister101.sns.common.capability.SNSCapabilities;
import mod.traister101.sns.common.menu.ContainerItemMenu;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.util.ContainerType;
import mod.traister101.sns.util.NBTHelper;
import mod.traister101.sns.util.SNSUtils;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class ContainerItem
extends Item
implements IItemSize {
    public static final String CONTENTS_TAG = "contents";
    public static final String TYPE_NO_PICKUP = "sns.status.item_container.no_pickup";
    public static final String HOLD_SHIFT_TOOLTIP = "sns.tooltip.item_container.tooltip.shift";
    public static final String PICKUP_TOOLTIP = "sns.tooltip.item_container.tooltip.pickup";
    public static final String VOID_TOOLTIP = "sns.tooltip.item_container.tooltip.void";
    public static final String SLOT_COUNT_TOOLTIP = "sns.tooltip.item_container.slot_count";
    public static final String SLOT_CAPACITY_TOOLTIP = "sns.tooltip.item_container.slot_capacity";
    public static final String ALLOWED_SIZE_TOOLTIP = "sns.tooltip.item_container.allowed_size";
    public static final String INVENTORY_INTERACTION_TOOLTIP = "sns.tooltip.item_container.tooltip.inventory_interaction";
    public final ContainerType type;

    public ContainerItem(Item.Properties properties, ContainerType type) {
        super(properties);
        this.type = type;
    }

    private static SimpleMenuProvider createMenuProvider(InteractionHand hand, ItemStack heldStack) {
        IItemHandler itemHandler = (IItemHandler)heldStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
        return new SimpleMenuProvider((windowId, inventory, unused) -> ContainerItemMenu.forHeld(windowId, inventory, itemHandler, hand), heldStack.m_41786_());
    }

    protected static void openMenu(ServerPlayer player, InteractionHand hand, ItemStack heldStack) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)ContainerItem.createMenuProvider(hand, heldStack), ContainerItemMenu.writeHeld(hand));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (!player.m_6144_()) {
                return InteractionResultHolder.m_19090_((Object)heldStack);
            }
            if (this.type.doesAutoPickup()) {
                boolean flag = !NBTHelper.isAutoPickup(heldStack);
                SNSUtils.sendTogglePacket(SNSUtils.ToggleType.PICKUP, flag);
                player.m_5661_((Component)SNSUtils.ToggleType.PICKUP.getTooltip(flag), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)TYPE_NO_PICKUP, (Object[])new Object[]{this.m_7626_(heldStack)}), true);
            }
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        if (!player.m_6144_()) {
            ContainerItem.openMenu((ServerPlayer)player, hand, heldStack);
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        return InteractionResultHolder.m_19096_((Object)heldStack);
    }

    public boolean m_142207_(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        if (!this.type.doesInventoryInteraction()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        if (!((Boolean)SNSConfig.SERVER.enableContainerInventoryInteraction.get()).booleanValue()) {
            return false;
        }
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            if (!slot.m_6657_()) {
                for (int slotIndex = handler.getSlots() - 1; slotIndex >= 0; --slotIndex) {
                    ItemStack extracted;
                    ItemStack leftover;
                    ItemStack simulate = handler.extractItem(slotIndex, 64, true);
                    if (simulate.m_41619_() || !(leftover = slot.m_150659_(extracted = handler.extractItem(slotIndex, 64, false))).m_41619_()) continue;
                    handler.insertItem(slotIndex, leftover, false);
                    player.f_36096_.m_6199_(slot.f_40218_);
                    this.playRemoveOneSound((Entity)player);
                    return true;
                }
                return false;
            }
            boolean slotsChanged = false;
            int initalCount = slot.m_7993_().m_41613_();
            for (int slotIndex = 0; slotIndex < handler.getSlots(); ++slotIndex) {
                ItemStack remainder = handler.insertItem(slotIndex, slot.m_7993_(), false);
                if (remainder.m_41613_() != initalCount || slotsChanged) {
                    slotsChanged = true;
                    slot.m_5852_(remainder);
                }
                if (remainder.m_41619_()) break;
            }
            if (slotsChanged) {
                player.f_36096_.m_6199_(slot.f_40218_);
                this.playInsertSound((Entity)player);
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean m_142305_(ItemStack itemStack, ItemStack carriedStack, Slot slot, ClickAction clickAction, Player player, SlotAccess carriedSlot) {
        if (!this.type.doesInventoryInteraction()) {
            return false;
        }
        if (!slot.m_150651_(player)) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        if (!((Boolean)SNSConfig.SERVER.enableContainerInventoryInteraction.get()).booleanValue()) {
            return false;
        }
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            if (carriedStack.m_41619_()) {
                for (int slotIndex = handler.getSlots() - 1; slotIndex >= 0; --slotIndex) {
                    ItemStack current = handler.getStackInSlot(slotIndex);
                    if (current.m_41619_()) continue;
                    carriedSlot.m_142104_(handler.extractItem(slotIndex, 64, false));
                    player.f_36096_.m_6199_(slot.f_40218_);
                    this.playRemoveOneSound((Entity)player);
                    return true;
                }
                return false;
            }
            boolean slotsChanged = false;
            int initalCount = carriedStack.m_41613_();
            ItemStack remainder = handler.insertItem(0, carriedStack, false);
            if (remainder.m_41613_() != initalCount) {
                slotsChanged = true;
                carriedSlot.m_142104_(remainder);
            }
            for (int slotIndex = 1; slotIndex < handler.getSlots(); ++slotIndex) {
                if ((remainder = handler.insertItem(slotIndex, remainder, false)).m_41613_() != initalCount || slotsChanged) {
                    slotsChanged = true;
                    carriedSlot.m_142104_(remainder);
                }
                if (remainder.m_41619_()) break;
            }
            if (!slotsChanged) {
                return false;
            }
            player.f_36096_.m_6199_(slot.f_40218_);
            this.playInsertSound((Entity)player);
            return true;
        }).orElse(false);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)HOLD_SHIFT_TOOLTIP).m_130940_(ChatFormatting.GRAY));
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)SLOT_COUNT_TOOLTIP, (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.type.getSlotCount())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)SLOT_CAPACITY_TOOLTIP, (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.type.getSlotCapacity())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)ALLOWED_SIZE_TOOLTIP, (Object[])new Object[]{Helpers.translateEnum((Enum)this.type.getAllowedSize()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        if (this.type.doesAutoPickup()) {
            tooltip.add((Component)Component.m_237110_((String)PICKUP_TOOLTIP, (Object[])new Object[]{SNSUtils.toggleTooltip(NBTHelper.isAutoPickup(itemStack))}).m_130940_(ChatFormatting.GRAY));
        }
        if (this.type.doesVoiding()) {
            tooltip.add((Component)Component.m_237110_((String)VOID_TOOLTIP, (Object[])new Object[]{SNSUtils.toggleTooltip(itemStack.getCapability(SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER).map(IVoidingItemHandler::isVoidingEnabled).orElse(false))}).m_130940_(ChatFormatting.GRAY));
        }
        if (this.type.doesInventoryInteraction()) {
            tooltip.add((Component)Component.m_237110_((String)INVENTORY_INTERACTION_TOOLTIP, (Object[])new Object[]{SNSUtils.toggleTooltip(true)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        if (!((Boolean)SNSConfig.CLIENT.displayItemContentsAsImages.get()).booleanValue()) {
            return super.m_142422_(itemStack);
        }
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            int width;
            int hight;
            int slotCount = handler.getSlots();
            switch (slotCount) {
                case 1: {
                    hight = 1;
                    width = 1;
                    break;
                }
                case 4: {
                    hight = 2;
                    width = 2;
                    break;
                }
                case 8: {
                    width = 4;
                    hight = 2;
                    break;
                }
                case 18: {
                    width = 9;
                    hight = 2;
                    break;
                }
                default: {
                    width = (int)Math.ceil((double)slotCount / 9.0);
                    hight = slotCount / width;
                }
            }
            return Helpers.getTooltipImage((IItemHandler)handler, (int)width, (int)hight, (int)0, (int)(slotCount - 1));
        }).orElse(super.m_142422_(itemStack));
    }

    public boolean m_5812_(ItemStack itemStack) {
        return (Boolean)SNSConfig.CLIENT.voidGlint.get() != false ? itemStack.getCapability(SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER).map(IVoidingItemHandler::isVoidingEnabled).orElse(false) : NBTHelper.isAutoPickup(itemStack);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack itemStack) {
        CompoundTag shareTag = super.getShareTag(itemStack);
        CompoundTag compoundTag = shareTag == null ? new CompoundTag() : shareTag;
        itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (handler instanceof ContainerItemHandler) {
                ContainerItemHandler containerItemHandler = (ContainerItemHandler)handler;
                compoundTag.m_128365_(CONTENTS_TAG, (Tag)containerItemHandler.serializeNBT());
            }
        });
        return compoundTag;
    }

    public void readShareTag(ItemStack itemStack, @Nullable CompoundTag compoundTag) {
        super.readShareTag(itemStack, compoundTag);
        if (compoundTag == null) {
            return;
        }
        itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (handler instanceof ContainerItemHandler) {
                ContainerItemHandler containerItemHandler = (ContainerItemHandler)handler;
                containerItemHandler.deserializeNBT(compoundTag.m_128469_(CONTENTS_TAG));
            }
        });
    }

    public final ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return this.type.getCapabilityProvider(itemStack, nbt);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public Size getSize(ItemStack itemStack) {
        return this.type.getSize(itemStack);
    }

    public Weight getWeight(ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            Weight weight;
            if (handler instanceof ContainerItemHandler) {
                ContainerItemHandler containerItemHandler = (ContainerItemHandler)handler;
                weight = containerItemHandler.getWeight();
            } else {
                weight = Weight.VERY_HEAVY;
            }
            return weight;
        }).orElse(Weight.VERY_HEAVY);
    }

    public int getDefaultStackSize(ItemStack itemStack) {
        return 1;
    }
}

