/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import java.util.function.BiFunction;
import mod.traister101.sns.common.SNSItemTags;
import mod.traister101.sns.common.capability.ContainerItemHandler;
import mod.traister101.sns.common.capability.LazyCapabilityProvider;
import mod.traister101.sns.common.capability.SNSCapabilities;
import mod.traister101.sns.common.items.LunchBoxItem;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.config.entries.ContainerConfig;
import mod.traister101.sns.util.ContainerType;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class DefaultContainers {
    public static final ContainerType STRAW_BASKET = new ContainerItemType<GenericHandler>("straw_basket", Size.NORMAL, SNSConfig.SERVER.strawBasket, GenericHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType LEATHER_SACK = new ContainerItemType<GenericHandler>("leather_sack", Size.NORMAL, SNSConfig.SERVER.leatherSack, GenericHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType BURLAP_SACK = new ContainerItemType<GenericHandler>("burlap_sack", Size.NORMAL, SNSConfig.SERVER.burlapSack, GenericHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType ORE_SACK = new ContainerItemType<OreSackHandler>("ore_sack", Size.NORMAL, SNSConfig.SERVER.oreSack, OreSackHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType SEED_POUCH = new ContainerItemType<SeedPouchHandler>("seed_pouch", Size.NORMAL, SNSConfig.SERVER.seedPouch, SeedPouchHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType FRAME_PACK = new ContainerItemType<FramePackHandler>("frame_pack", Size.HUGE, SNSConfig.SERVER.framePack, FramePackHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType LUNCHBOX = new ContainerItemType<LunchBoxItem.LunchboxHandler>("lunchbox", Size.NORMAL, SNSConfig.SERVER.lunchBox, LunchBoxItem.LunchboxHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.LUNCHBOX, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);
    public static final ContainerType QUIVER = new ContainerItemType<QuiverHandler>("quiver", Size.HUGE, SNSConfig.SERVER.quiver, QuiverHandler::new, ForgeCapabilities.ITEM_HANDLER, SNSCapabilities.ITEM_VOIDING_ITEM_HANDLER);

    private record ContainerItemType<Handler extends INBTSerializable<CompoundTag>>(String name, Size size, ContainerConfig containerConfig, BiFunction<ContainerType, ItemStack, Handler> handlerFactory, Capability<? super Handler>[] capabilities) implements ContainerType
    {
        @Override
        public int getSlotCount() {
            return (Integer)this.containerConfig.slotCount.get();
        }

        @Override
        public int getSlotCapacity() {
            return (Integer)this.containerConfig.slotCap.get();
        }

        @Override
        public boolean doesAutoPickup() {
            return (Boolean)this.containerConfig.doPickup.get();
        }

        @Override
        public boolean doesVoiding() {
            return (Boolean)this.containerConfig.doVoiding.get();
        }

        @Override
        public boolean doesInventoryInteraction() {
            return (Boolean)this.containerConfig.doInventoryTransfer.get();
        }

        @Override
        public Size getAllowedSize() {
            return (Size)this.containerConfig.allowedSize.get();
        }

        @Override
        public Size getSize(ItemStack itemStack) {
            return this.size;
        }

        @Override
        public ICapabilityProvider getCapabilityProvider(ItemStack itemStack, @Nullable CompoundTag nbt) {
            return new LazyCapabilityProvider.LazySerializedCapabilityProvider<Handler>(() -> (INBTSerializable)this.handlerFactory.apply(this, itemStack), this.capabilities);
        }

        public String m_7912_() {
            return this.name;
        }
    }

    private static class QuiverHandler
    extends ContainerItemHandler {
        public QuiverHandler(ContainerType type, ItemStack itemStack) {
            super(type, itemStack);
        }

        @Override
        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            if (!((Boolean)SNSConfig.SERVER.allAllowFood.get()).booleanValue() && itemStack.m_204117_(TFCTags.Items.FOODS)) {
                return false;
            }
            return itemStack.m_204117_(SNSItemTags.ALLOWED_IN_QUIVER) && super.isItemValid(slotIndex, itemStack);
        }
    }

    private static class FramePackHandler
    extends GenericHandler {
        public FramePackHandler(ContainerType type, ItemStack itemStack) {
            super(type, itemStack);
        }

        public int getStackLimit(int slotIndex, ItemStack itemStack) {
            return itemStack.m_41741_();
        }
    }

    private static class OreSackHandler
    extends ContainerItemHandler {
        public OreSackHandler(ContainerType type, ItemStack itemStack) {
            super(type, itemStack);
        }

        @Override
        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            if (!((Boolean)SNSConfig.SERVER.allAllowFood.get()).booleanValue() && itemStack.m_204117_(TFCTags.Items.FOODS)) {
                return false;
            }
            return itemStack.m_204117_(SNSItemTags.ALLOWED_IN_ORE_SACK) && super.isItemValid(slotIndex, itemStack);
        }
    }

    private static class SeedPouchHandler
    extends ContainerItemHandler {
        public SeedPouchHandler(ContainerType type, ItemStack itemStack) {
            super(type, itemStack);
        }

        @Override
        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            if (!((Boolean)SNSConfig.SERVER.allAllowFood.get()).booleanValue() && itemStack.m_204117_(TFCTags.Items.FOODS)) {
                return false;
            }
            return itemStack.m_204117_(SNSItemTags.ALLOWED_IN_SEED_POUCH) && super.isItemValid(slotIndex, itemStack);
        }
    }

    private static class GenericHandler
    extends ContainerItemHandler {
        public GenericHandler(ContainerType type, ItemStack itemStack) {
            super(type, itemStack);
        }

        @Override
        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            if (!((Boolean)SNSConfig.SERVER.allAllowFood.get()).booleanValue() && itemStack.m_204117_(TFCTags.Items.FOODS)) {
                return false;
            }
            if (!((Boolean)SNSConfig.SERVER.allAllowOre.get()).booleanValue() && (itemStack.m_204117_(SNSItemTags.TFC_SMALL_ORE_PIECES) || itemStack.m_204117_(SNSItemTags.TFC_ORE_PIECES))) {
                return false;
            }
            return super.isItemValid(slotIndex, itemStack);
        }
    }
}

