/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.traister101.sns.client.models.FancyHikingBootsModel;
import mod.traister101.sns.client.models.NoFloofHikingBootsModel;
import mod.traister101.sns.client.models.VanillaHikingBootsModel;
import mod.traister101.sns.common.attribute.SNSAttributes;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.config.entries.BootsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HikingBootsItem
extends ArmorItem {
    public static final String LAST_STEP_NBT_KEY = "lastStep";
    public static final String LAST_STEP_X_NBT_KEY = "x";
    public static final String LAST_STEP_Z_NBT_KEY = "z";
    public static final String STEPS_NBT_KEY = "steps";
    public static final String PREVENT_SLOW_TOOLTIP = "sns.tooltip.hiking_boots.prevents_slow";
    private static final UUID HIKING_BOOTS_UUID = UUID.fromString("1498ff98-5730-4216-a827-857c81e2e12c");
    private final Supplier<Double> movementSpeed;
    private final Supplier<Double> stepHeight;
    private final Supplier<Double> fallPadding;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;

    public HikingBootsItem(Item.Properties properties, ArmorMaterial armorMaterial, Supplier<Double> movementSpeed, Supplier<Double> stepHeight, Supplier<Double> fallPadding) {
        super(armorMaterial, ArmorItem.Type.BOOTS, properties);
        this.movementSpeed = movementSpeed;
        this.stepHeight = stepHeight;
        this.fallPadding = fallPadding;
    }

    public HikingBootsItem(Item.Properties properties, ArmorMaterial armorMaterial, BootsConfig bootsConfig) {
        this(properties, armorMaterial, (Supplier<Double>)bootsConfig.movementSpeed, (Supplier<Double>)bootsConfig.stepHeight, (Supplier<Double>)bootsConfig.fallPadding);
    }

    public static int getSteps(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_(STEPS_NBT_KEY);
    }

    public static void setSteps(ItemStack itemStack, int steps) {
        itemStack.m_41784_().m_128405_(STEPS_NBT_KEY, steps);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (slot != EquipmentSlot.FEET) {
            return super.getAttributeModifiers(slot, itemStack);
        }
        if (this.attributeModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, itemStack));
            if (0.0 < this.movementSpeed.get()) {
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(HIKING_BOOTS_UUID, "Movement Speed", this.movementSpeed.get().doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (0.0 < this.stepHeight.get()) {
                builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(HIKING_BOOTS_UUID, "Step Height", this.stepHeight.get().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (0.0 < this.fallPadding.get()) {
                builder.put((Object)((Attribute)SNSAttributes.EXTRA_FALL_DISTANCE.get()), (Object)new AttributeModifier(HIKING_BOOTS_UUID, "Fall Padding", this.fallPadding.get().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            this.attributeModifiers = builder.build();
        }
        return this.attributeModifiers;
    }

    public void onArmorTick(ItemStack itemStack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (HikingBootsItem.getSteps(itemStack) > (Integer)SNSConfig.SERVER.bootsStepPerDamage.get()) {
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.FEET));
            HikingBootsItem.setSteps(itemStack, 0);
        }
        CompoundTag lastStep = itemStack.m_41698_(LAST_STEP_NBT_KEY);
        double lastX = lastStep.m_128459_(LAST_STEP_X_NBT_KEY);
        double lastZ = lastStep.m_128459_(LAST_STEP_Z_NBT_KEY);
        if (!(!player.m_20096_() || player.m_20159_() || player.m_7500_() || 0 >= (Integer)SNSConfig.SERVER.bootsStepPerDamage.get() || lastX == player.f_19790_ && lastZ == player.f_19792_)) {
            HikingBootsItem.setSteps(itemStack, HikingBootsItem.getSteps(itemStack) + 1);
            lastStep.m_128347_(LAST_STEP_X_NBT_KEY, player.f_19790_);
            lastStep.m_128347_(LAST_STEP_Z_NBT_KEY, player.f_19792_);
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlot slot, String type) {
        return "sns:textures/models/armor/hiking_boots.png";
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.m_237115_((String)PREVENT_SLOW_TOOLTIP));
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final EnumMap<BootModelType, HumanoidModel<?>> models = new EnumMap(BootModelType.class);

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return this.models.computeIfAbsent((BootModelType)((Object)SNSConfig.CLIENT.bootModelType.get()), bootModelType -> {
                    EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
                    return switch (bootModelType) {
                        default -> throw new IncompatibleClassChangeError();
                        case BootModelType.FANCY -> new FancyHikingBootsModel(entityModels.m_171103_(FancyHikingBootsModel.LAYER_LOCATION));
                        case BootModelType.NO_FLOOF -> new NoFloofHikingBootsModel(entityModels.m_171103_(NoFloofHikingBootsModel.LAYER_LOCATION));
                        case BootModelType.VANILLA -> new VanillaHikingBootsModel(entityModels.m_171103_(VanillaHikingBootsModel.LAYER_LOCATION));
                    };
                });
            }
        });
    }

    public static enum BootModelType {
        FANCY,
        NO_FLOOF,
        VANILLA;

    }
}

