/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import mod.traister101.sns.common.attribute.SNSAttributes;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.config.entries.HorseshoesConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class HorseshoesItem
extends Item {
    public static final String LAST_STEP_NBT_KEY = "lastStep";
    public static final String LAST_STEP_X_NBT_KEY = "x";
    public static final String LAST_STEP_Z_NBT_KEY = "z";
    public static final String STEPS_NBT_KEY = "steps";
    public static final UUID HORSE_SHOE_UUID = UUID.fromString("de872635-2298-412b-beac-667462412c28");
    public static final String HORSESHOE_MODIFIER_TOOLTIP = "sns.tooltip.horseshoe.modifier";
    private final Supplier<Double> movementSpeed;
    private final Supplier<Double> bonusFallDistance;
    private final Supplier<Double> bonusStepDistance;
    private final AtomicReference<Object> attributeModifiers = new AtomicReference();

    public HorseshoesItem(Item.Properties properties, Supplier<Double> movementSpeed, Supplier<Double> bonusFallDistance, Supplier<Double> bonusStepDistance) {
        super(properties);
        this.movementSpeed = movementSpeed;
        this.bonusFallDistance = bonusFallDistance;
        this.bonusStepDistance = bonusStepDistance;
    }

    public HorseshoesItem(Item.Properties properties, HorseshoesConfig horseshoesConfig) {
        this(properties, (Supplier<Double>)horseshoesConfig.movementSpeed, (Supplier<Double>)horseshoesConfig.bonusFallDistance, (Supplier<Double>)horseshoesConfig.bonusStepDistance);
    }

    public static int getSteps(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_(STEPS_NBT_KEY);
    }

    public static void setSteps(ItemStack itemStack, int steps) {
        itemStack.m_41784_().m_128405_(STEPS_NBT_KEY, steps);
    }

    public static void horseshoeTick(ItemStack itemStack, Level level, AbstractHorse horse) {
        if (level.f_46443_) {
            return;
        }
        if (HorseshoesItem.getSteps(itemStack) > (Integer)SNSConfig.SERVER.horseshoesStepsPerDamage.get()) {
            itemStack.m_41622_(1, (LivingEntity)horse, e -> e.m_21166_(EquipmentSlot.FEET));
            HorseshoesItem.setSteps(itemStack, 0);
        }
        CompoundTag lastStep = itemStack.m_41698_(LAST_STEP_NBT_KEY);
        double lastX = lastStep.m_128459_(LAST_STEP_X_NBT_KEY);
        double lastZ = lastStep.m_128459_(LAST_STEP_Z_NBT_KEY);
        if (horse.m_20096_() && !horse.m_20159_() && (Integer)SNSConfig.SERVER.horseshoesStepsPerDamage.get() > 0 && (lastX != horse.f_19790_ || lastZ != horse.f_19792_)) {
            HorseshoesItem.setSteps(itemStack, HorseshoesItem.getSteps(itemStack) + 1);
            lastStep.m_128347_(LAST_STEP_X_NBT_KEY, horse.f_19790_);
            lastStep.m_128347_(LAST_STEP_Z_NBT_KEY, horse.f_19792_);
        }
    }

    public static int getHorseshoesSlot(AbstractHorse horse) {
        return horse.m_7482_() ? 2 : 1;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Multimap<Attribute, AttributeModifier> modifiers = this.getAttributeModifiers();
        if (modifiers.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)HORSESHOE_MODIFIER_TOOLTIP).m_130940_(ChatFormatting.GRAY));
        for (Map.Entry entry : modifiers.entries()) {
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            double amount = modifier.m_22218_();
            double displayAmount = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? amount * 10.0 : amount) : amount * 100.0;
            if (amount > 0.0) {
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(displayAmount), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(amount < 0.0)) continue;
            tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(displayAmount * -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        Object $value = this.attributeModifiers.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.attributeModifiers;
            synchronized (atomicReference) {
                $value = this.attributeModifiers.get();
                if ($value == null) {
                    Multimap actualValue = (Multimap)Util.m_137537_(() -> {
                        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(HORSE_SHOE_UUID, "Horseshoe movement speed bonus", this.movementSpeed.get().doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
                        builder.put((Object)((Attribute)SNSAttributes.EXTRA_FALL_DISTANCE.get()), (Object)new AttributeModifier(HORSE_SHOE_UUID, "Horseshoe fall distance bonus", this.bonusFallDistance.get().doubleValue(), AttributeModifier.Operation.ADDITION));
                        builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(HORSE_SHOE_UUID, "Horseshoe step bonus", this.bonusStepDistance.get().doubleValue(), AttributeModifier.Operation.ADDITION));
                        return builder.build();
                    });
                    $value = actualValue == null ? this.attributeModifiers : actualValue;
                    this.attributeModifiers.set($value);
                }
            }
        }
        return (Multimap)($value == this.attributeModifiers ? null : $value);
    }
}

