/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.items;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import mod.traister101.sns.common.SNSEntityTags;
import mod.traister101.sns.config.SNSConfig;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.slf4j.Logger;

public class MobNetItem
extends Item
implements IItemSize {
    public static final String CAPTURED_MOB_KEY = "captured_mob";
    public static final String CANNOT_CAPTURE_PLAYERS = "sns.status.mob_net.cannot_capture_players";
    public static final String CANNOT_CAPTURE_GENERIC = "sns.status.mob_net.cannot_capture_generic";
    public static final String CANNOT_CAPTURE_SIZE = "sns.status.mob_net.cannot_capture_size";
    public static final String CANNOT_PLACE = "sns.status.mob_net.cannot_place";
    public static final String STACK_NAME = "sns.stack_name.mob_net.with_mob";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MobNetItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction direction = context.m_43719_();
        if (direction != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        ItemStack heldStack = context.m_43722_();
        CompoundTag capturedMobTag = heldStack.m_41737_(CAPTURED_MOB_KEY);
        if (capturedMobTag == null) {
            return InteractionResult.FAIL;
        }
        Vec3 clickLocation = context.m_43720_();
        Optional optEntityType = EntityType.m_20637_((CompoundTag)capturedMobTag);
        if (optEntityType.isEmpty()) {
            return InteractionResult.FAIL;
        }
        EntityType entityType = (EntityType)optEntityType.get();
        AABB aabb = entityType.m_20680_().m_20393_(clickLocation);
        Player player = context.m_43723_();
        if (!level.m_45756_(null, aabb) || !level.m_45933_(null, aabb).isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237110_((String)CANNOT_PLACE, (Object[])new Object[]{entityType.m_20676_()}), true);
            }
            return InteractionResult.FAIL;
        }
        float rotation = (float)Mth.m_14107_((double)(((double)Mth.m_14177_((float)(context.m_7074_() - 180.0f)) + 22.5) / 45.0)) * 45.0f;
        Entity entity = entityType.m_20615_(level);
        if (entity == null) {
            LOGGER.warn("Cannot load {} from mob net.", (Object)entityType);
            return InteractionResult.FAIL;
        }
        entity.m_20258_(capturedMobTag);
        entity.m_7678_(clickLocation.f_82479_, clickLocation.f_82480_, clickLocation.f_82481_, rotation, 0.0f);
        level.m_7967_(entity);
        entity.m_146852_(GameEvent.f_157810_, (Entity)player);
        if (!level.f_46443_ && player != null) {
            heldStack.m_41749_(CAPTURED_MOB_KEY);
            if ((double)player.m_217043_().m_188501_() < 0.75) {
                player.m_21190_(context.m_43724_());
                heldStack.m_41774_(1);
            } else {
                player.m_21008_(context.m_43724_(), heldStack);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        float entitySize;
        EntityType entityType = livingEntity.m_6095_();
        if (entityType == EntityType.f_20532_) {
            player.m_5661_((Component)Component.m_237115_((String)CANNOT_CAPTURE_PLAYERS), true);
            return InteractionResult.FAIL;
        }
        if (!entityType.m_204039_(SNSEntityTags.NETABLE_MOBS)) {
            player.m_5661_((Component)Component.m_237110_((String)CANNOT_CAPTURE_GENERIC, (Object[])new Object[]{entityType.m_20676_()}), true);
            return InteractionResult.FAIL;
        }
        if (livingEntity instanceof TFCAnimalProperties) {
            TFCAnimalProperties animalProperties = (TFCAnimalProperties)livingEntity;
            v0 = livingEntity.m_20205_() * animalProperties.getAgeScale();
        } else {
            v0 = entitySize = livingEntity.m_20205_();
        }
        if ((double)entitySize >= (Double)SNSConfig.SERVER.maximumNetCaptureSize.get()) {
            player.m_5661_((Component)Component.m_237110_((String)CANNOT_CAPTURE_SIZE, (Object[])new Object[]{entityType.m_20676_()}), true);
            return InteractionResult.FAIL;
        }
        CompoundTag compoundTag = new CompoundTag();
        if (!livingEntity.m_20223_(compoundTag)) {
            LOGGER.warn("Failed to save {}", (Object)livingEntity.m_6095_());
            return InteractionResult.FAIL;
        }
        if (itemStack.m_41613_() > 1) {
            ItemStack split = itemStack.m_41620_(1);
            split.m_41784_().m_128365_(CAPTURED_MOB_KEY, (Tag)compoundTag);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)split);
        } else {
            itemStack.m_41784_().m_128365_(CAPTURED_MOB_KEY, (Tag)compoundTag);
        }
        livingEntity.m_142687_(Entity.RemovalReason.KILLED);
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public Component m_7626_(ItemStack itemStack) {
        CompoundTag capturedMobTag = itemStack.m_41737_(CAPTURED_MOB_KEY);
        if (capturedMobTag == null) {
            return super.m_7626_(itemStack);
        }
        return EntityType.m_20637_((CompoundTag)capturedMobTag).map(entityType -> Component.m_237110_((String)STACK_NAME, (Object[])new Object[]{super.m_7626_(itemStack), entityType.m_20676_()})).orElse(super.m_7626_(itemStack));
    }

    public Size getSize(ItemStack itemStack) {
        return itemStack.m_41782_() ? Size.HUGE : Size.LARGE;
    }

    public Weight getWeight(ItemStack itemStack) {
        return itemStack.m_41782_() ? Weight.VERY_HEAVY : Weight.MEDIUM;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        return itemStack.m_41782_() ? 1 : 16;
    }
}

