/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.menu;

import com.google.common.base.Supplier;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import mod.traister101.esc.common.menu.ExtendedSlotCapacityMenu;
import mod.traister101.esc.common.slot.ExtendedSlotItemHandler;
import mod.traister101.sns.common.items.ContainerItem;
import mod.traister101.sns.common.menu.SNSMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ContainerItemMenu
extends ExtendedSlotCapacityMenu {
    public static final int OFFHAND_MAGIC_INDEX = -1;
    private static final Set<ClickType> ILLEGAL_ITEM_CLICKS = EnumSet.of(ClickType.QUICK_MOVE, ClickType.PICKUP, ClickType.THROW, ClickType.SWAP);
    public final Supplier<ItemStack> containerStackSupplier;
    protected final int hotbarIndex;
    protected int containerItemIndex;

    private ContainerItemMenu(int windowId, Inventory inventory, IItemHandler handler, InteractionHand hand) {
        super((MenuType)SNSMenus.CONTAINER_ITEM_MENU.get(), windowId, handler.getSlots());
        if (hand == InteractionHand.MAIN_HAND) {
            this.hotbarIndex = inventory.f_35977_;
            this.containerItemIndex = this.containerSlots + inventory.f_35977_ + 27;
        } else {
            this.hotbarIndex = -1;
            this.containerItemIndex = Integer.MIN_VALUE;
        }
        this.containerStackSupplier = () -> hand == InteractionHand.MAIN_HAND ? ((Slot)this.f_38839_.get(this.containerItemIndex)).m_7993_() : inventory.f_35978_.m_21206_();
        this.addContainerSlots(handler);
        this.addPlayerInventorySlots(inventory);
    }

    private ContainerItemMenu(int windowId, Inventory inventory, IItemHandler handler, int inventorySlotIndex) {
        super((MenuType)SNSMenus.CONTAINER_ITEM_MENU.get(), windowId, handler.getSlots());
        this.hotbarIndex = Integer.MIN_VALUE;
        this.containerItemIndex = this.containerSlots + inventorySlotIndex - 9;
        this.containerStackSupplier = () -> inventory.m_8020_(inventorySlotIndex);
        this.addContainerSlots(handler);
        this.addPlayerInventorySlots(inventory);
    }

    private ContainerItemMenu(int windowId, Inventory inventory, IItemHandler handler, Supplier<ItemStack> containerStackSupplier) {
        super((MenuType)SNSMenus.CONTAINER_ITEM_MENU.get(), windowId, handler.getSlots());
        this.hotbarIndex = Integer.MIN_VALUE;
        this.containerItemIndex = Integer.MIN_VALUE;
        this.containerStackSupplier = containerStackSupplier;
        this.addContainerSlots(handler);
        this.addPlayerInventorySlots(inventory);
    }

    public static Consumer<FriendlyByteBuf> writeCurios(String identifier, int index) {
        return friendlyByteBuf -> {
            friendlyByteBuf.m_130068_((Enum)Type.WORN);
            friendlyByteBuf.m_130070_(identifier);
            friendlyByteBuf.m_130130_(index);
        };
    }

    public static Consumer<FriendlyByteBuf> writeInventory(int slotIndex) {
        return friendlyByteBuf -> {
            friendlyByteBuf.m_130068_((Enum)Type.INVENTORY);
            friendlyByteBuf.m_130130_(slotIndex);
        };
    }

    public static Consumer<FriendlyByteBuf> writeHeld(InteractionHand hand) {
        return friendlyByteBuf -> {
            friendlyByteBuf.m_130068_((Enum)Type.HELD);
            friendlyByteBuf.writeBoolean(hand == InteractionHand.MAIN_HAND);
        };
    }

    static ContainerItemMenu fromNetwork(int windowId, Inventory inventory, FriendlyByteBuf byteBuf) {
        return switch ((Type)byteBuf.m_130066_(Type.class)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.HELD -> {
                InteractionHand hand = byteBuf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack heldStack = inventory.f_35978_.m_21120_(hand);
                IItemHandler itemHandler = (IItemHandler)heldStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
                yield ContainerItemMenu.forHeld(windowId, inventory, itemHandler, hand);
            }
            case Type.INVENTORY -> {
                int slotIndex = byteBuf.m_130242_();
                IItemHandler itemHandler = (IItemHandler)inventory.m_8020_(slotIndex).getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
                yield ContainerItemMenu.forInventory(windowId, inventory, itemHandler, slotIndex);
            }
            case Type.WORN -> {
                ICuriosItemHandler curiosItemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)inventory.f_35978_).resolve().orElseThrow();
                SlotResult slotResult = (SlotResult)curiosItemHandler.findFirstCurio(itemStack -> itemStack.m_41720_() instanceof ContainerItem).orElseThrow();
                ItemStack stack = slotResult.stack();
                IItemHandler itemHandler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElseThrow();
                yield ContainerItemMenu.forUnIndexableStack(windowId, inventory, itemHandler, (Supplier<ItemStack>)((Supplier)() -> ((SlotResult)slotResult).stack()));
            }
        };
    }

    public static ContainerItemMenu forHeld(int windowId, Inventory inventory, IItemHandler handler, InteractionHand hand) {
        return new ContainerItemMenu(windowId, inventory, handler, hand);
    }

    public static ContainerItemMenu forInventory(int windowId, Inventory inventory, IItemHandler handler, int inventorySlotIndex) {
        return new ContainerItemMenu(windowId, inventory, handler, inventorySlotIndex);
    }

    public static ContainerItemMenu forUnIndexableStack(int windowId, Inventory inventory, IItemHandler handler, Supplier<ItemStack> containerStackSupplier) {
        return new ContainerItemMenu(windowId, inventory, handler, containerStackSupplier);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            if (slotIndex < this.containerSlots ? !this.m_38903_(slotStack, this.containerSlots, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            return slotStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotIndex, int mouseButtom, ClickType clickType, Player player) {
        if (slotIndex == this.containerItemIndex && ILLEGAL_ITEM_CLICKS.contains(clickType)) {
            return;
        }
        if (mouseButtom == this.hotbarIndex && clickType == ClickType.SWAP) {
            return;
        }
        if (mouseButtom == 40 && clickType == ClickType.SWAP && this.hotbarIndex == -1) {
            return;
        }
        super.m_150399_(slotIndex, mouseButtom, clickType, player);
    }

    public boolean m_6875_(Player player) {
        return !this.getContainerStack().m_41619_();
    }

    public int getContainerSlots() {
        return this.containerSlots;
    }

    public final ItemStack getContainerStack() {
        return (ItemStack)this.containerStackSupplier.get();
    }

    protected void addContainerSlots(IItemHandler handler) {
        switch (this.containerSlots) {
            case 1: {
                this.addSlots(handler, 1, 1, 80, 32);
                break;
            }
            case 4: {
                this.addSlots(handler, 2, 2, 71, 23);
                break;
            }
            case 8: {
                this.addSlots(handler, 2, 4, 53, 23);
                break;
            }
            case 18: {
                this.addSlots(handler, 2, 9, 8, 23);
                break;
            }
            default: {
                int rows = Math.round((float)this.containerSlots / 9.0f);
                int columns = this.containerSlots / rows;
                this.addSlots(handler, rows, columns);
            }
        }
    }

    private void addSlots(IItemHandler handler, int rows, int columns, int startX, int startY) {
        assert (rows != 0) : "Cannot have zero rows of slots";
        assert (columns != 0) : "Cannot have zero columns of slots";
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int yPosition = startY + row * 18;
                int xPosition = startX + column * 18;
                int index = column + row * columns;
                this.m_38897_((Slot)new ExtendedSlotItemHandler(handler, index, xPosition, yPosition));
            }
        }
    }

    private void addSlots(IItemHandler handler, int rows, int columns) {
        if (rows > 1) {
            this.addSlots(handler, rows - 1, 9, 8, 18);
        }
        for (int column = 0; column < columns; ++column) {
            int yPosition = 18 * (rows - 1) + 18;
            int xPosition = 8 + column * 18;
            int index = column + (rows - 1) * columns;
            this.m_38897_((Slot)new ExtendedSlotItemHandler(handler, index, xPosition, yPosition));
        }
    }

    protected final void addPlayerInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    static enum Type {
        HELD,
        INVENTORY,
        WORN;

    }
}

