/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.config;

import mod.traister101.sns.config.entries.BootsConfig;
import mod.traister101.sns.config.entries.ContainerConfig;
import mod.traister101.sns.config.entries.HorseshoesConfig;
import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfig {
    public final ContainerConfig strawBasket;
    public final ContainerConfig leatherSack;
    public final ContainerConfig burlapSack;
    public final ContainerConfig oreSack;
    public final ContainerConfig seedPouch;
    public final ContainerConfig framePack;
    public final ContainerConfig lunchBox;
    public final ContainerConfig quiver;
    public final ForgeConfigSpec.IntValue bootsStepPerDamage;
    public final BootsConfig hikingBoots;
    public final BootsConfig steelToeHikingBoots;
    public final BootsConfig blackSteelToeHikingBoots;
    public final BootsConfig blueSteelToeHikingBoots;
    public final BootsConfig redSteelToeHikingBoots;
    public final ForgeConfigSpec.IntValue horseshoesStepsPerDamage;
    public final HorseshoesConfig steelHorseshoes;
    public final HorseshoesConfig blackSteelHorseshoes;
    public final HorseshoesConfig blueSteelHorseshoes;
    public final HorseshoesConfig redSteelHorseshoes;
    public final ForgeConfigSpec.BooleanValue doPickup;
    public final ForgeConfigSpec.BooleanValue doVoiding;
    public final ForgeConfigSpec.BooleanValue allPickBlock;
    public final ForgeConfigSpec.BooleanValue allAllowOre;
    public final ForgeConfigSpec.BooleanValue allAllowFood;
    public final ForgeConfigSpec.BooleanValue enableContainerInventoryInteraction;
    public final ForgeConfigSpec.DoubleValue traitLunchboxModifier;
    public final ForgeConfigSpec.DoubleValue maximumNetCaptureSize;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Container Item Config");
        this.strawBasket = ContainerConfig.buildContainerConfig(builder, "Straw Basket", true, true, true, 4, 32, Size.SMALL);
        this.leatherSack = ContainerConfig.buildContainerConfig(builder, "Leather Sack", false, false, true, 4, 64, Size.NORMAL);
        this.burlapSack = ContainerConfig.buildContainerConfig(builder, "Burlap Sack", true, true, false, 8, 48, Size.SMALL);
        this.oreSack = ContainerConfig.buildContainerConfig(builder, "Ore Sack", true, false, true, 1, 512, Size.SMALL);
        this.seedPouch = ContainerConfig.buildContainerConfig(builder, "Seed Pouch", true, false, true, 27, 64, Size.SMALL);
        this.framePack = ContainerConfig.buildContainerConfig(builder, "Frame Pack", false, false, false, 18, 64, Size.LARGE);
        this.lunchBox = ContainerConfig.buildContainerConfig(builder, "Lunch Box", false, false, true, 8, 4, Size.NORMAL);
        this.quiver = ContainerConfig.buildContainerConfig(builder, "Quiver", true, false, false, 8, 32, Size.VERY_LARGE);
        builder.pop();
        builder.push("Boot config");
        this.bootsStepPerDamage = builder.comment("The amount of steps taken before one point of durability is lost").defineInRange("bootsStepPerDamage", 500, 0, Integer.MAX_VALUE);
        this.hikingBoots = BootsConfig.buildBootsConfig(builder, "Hiking Boots", 0.05, 0.0, 0.5);
        this.steelToeHikingBoots = BootsConfig.buildBootsConfig(builder, "Steel Toe Boots", 0.1, 0.5, 1.0);
        this.blackSteelToeHikingBoots = BootsConfig.buildBootsConfig(builder, "Black Steel Toe Boots", 0.15, 0.5, 2.0);
        this.blueSteelToeHikingBoots = BootsConfig.buildBootsConfig(builder, "Blue Steel Toe Boots", 0.2, 0.5, 5.0);
        this.redSteelToeHikingBoots = BootsConfig.buildBootsConfig(builder, "Red Steel Toe Boots", 0.2, 0.5, 5.0);
        builder.pop();
        builder.push("Horseshoes config");
        this.horseshoesStepsPerDamage = builder.comment("The amount of steps taken before one point of durability is lost").defineInRange("horseshoesStepsPerDamage", 500, 0, Integer.MAX_VALUE);
        this.steelHorseshoes = HorseshoesConfig.buildConfig(builder, "Steel Horseshoes", 0.05, 2.0, 0.0);
        this.blackSteelHorseshoes = HorseshoesConfig.buildConfig(builder, "Black Steel Horseshoes", 0.1, 2.0, 0.0);
        this.blueSteelHorseshoes = HorseshoesConfig.buildConfig(builder, "Blue Steel Horseshoes", 0.2, 5.0, 1.0);
        this.redSteelHorseshoes = HorseshoesConfig.buildConfig(builder, "Red Steel Horseshoes", 0.2, 5.0, 1.0);
        builder.pop();
        builder.push("Global config");
        this.doPickup = builder.comment("Global control for automatic pickup, this will not force enable for every type").worldRestart().define("doPickup", true);
        this.doVoiding = builder.comment("A global toggle for item voiding, this will not force enable for every type").define("doVoiding", true);
        this.allPickBlock = builder.comment("This allows other containers such as vessels to support the pick block search").define("allPickBlock", false);
        this.allAllowOre = builder.comment("This makes all container types capable of holding ore").define("allAllowOre", false);
        this.allAllowFood = builder.comment("This makes all container types capable of holding food although they won't preserve it!").define("allAllowFood", false);
        this.enableContainerInventoryInteraction = builder.comment("This allows containers to have items inserted and extracted from them via the inventory like vanilla Bundles").define("enableContainerInventoryInteraction", true);
        this.traitLunchboxModifier = builder.comment("The modifier for the 'Lunchbox' food trait. Values less than 1 extend food lifetime, values greater than one decrease it. A value of zero stops decay.").defineInRange("traitLunchboxModifier", 0.6, 0.0, Double.MAX_VALUE);
        this.maximumNetCaptureSize = builder.comment("The maximum size of an entity which mob nets can capture. This is not directly related to TFC's animal size stat.").defineInRange("maximumNetCaptureSize", 0.5, 0.0, Double.MAX_VALUE);
    }
}

