/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.config.entries;

import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ContainerConfig {
    public final ForgeConfigSpec.BooleanValue doPickup;
    public final ForgeConfigSpec.BooleanValue doVoiding;
    public final ForgeConfigSpec.BooleanValue doInventoryTransfer;
    public final ForgeConfigSpec.IntValue slotCount;
    public final ForgeConfigSpec.IntValue slotCap;
    public final ForgeConfigSpec.EnumValue<Size> allowedSize;

    public static ContainerConfig buildContainerConfig(ForgeConfigSpec.Builder builder, String containerName, boolean doPickup, boolean doVoiding, boolean doInventoryTransfer, int slotCount, int slotCap, Size allowedSize) {
        builder.push(containerName);
        ContainerConfig containerConfig = new ContainerConfig(builder.comment("Determines if this container will automatically pickup items").define("doPickup", doPickup), builder.comment("Determines if this container can void items on pickup").define("doVoiding", doVoiding), builder.comment("Determines if this container can transfer items in an inventory").define("doInventoryTransfer", doInventoryTransfer), builder.comment("Controls the amount of slots this container has").defineInRange("slotCount", slotCount, 1, 27), builder.comment("Item stack max for the type of container").defineInRange("slotCap", slotCap, 1, 512), (ForgeConfigSpec.EnumValue<Size>)builder.comment("The maximum item size allowed in the container").defineEnum("allowedSize", (Enum)allowedSize));
        builder.pop();
        return containerConfig;
    }

    private ContainerConfig(ForgeConfigSpec.BooleanValue doPickup, ForgeConfigSpec.BooleanValue doVoiding, ForgeConfigSpec.BooleanValue doInventoryTransfer, ForgeConfigSpec.IntValue slotCount, ForgeConfigSpec.IntValue slotCap, ForgeConfigSpec.EnumValue<Size> allowedSize) {
        this.doPickup = doPickup;
        this.doVoiding = doVoiding;
        this.doInventoryTransfer = doInventoryTransfer;
        this.slotCount = slotCount;
        this.slotCap = slotCap;
        this.allowedSize = allowedSize;
    }
}

