/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.traister101.sns.network.ServerboundOpenContainerPacket;
import mod.traister101.sns.network.ServerboundPacketCycleSlotPacket;
import mod.traister101.sns.network.ServerboundPickBlockPacket;
import mod.traister101.sns.network.ServerboundTogglePacket;
import mod.traister101.sns.network.ServerboundToggleSlotVoidingPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableInt;

public final class SNSPacketHandler {
    private static final String VERSION = ModList.get().getModFileById("sns").versionString();
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sns", "main"), () -> VERSION, VERSION::equals, VERSION::equals);
    private static final MutableInt ID = new MutableInt(0);

    public static void send(PacketDistributor.PacketTarget target, Object message) {
        CHANNEL.send(target, message);
    }

    public static void sendToServer(Object message) {
        SNSPacketHandler.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static void init() {
        SNSPacketHandler.register(ServerboundPickBlockPacket.class, ServerboundPickBlockPacket::encode, ServerboundPickBlockPacket::new, ServerboundPickBlockPacket::handle);
        SNSPacketHandler.register(ServerboundTogglePacket.class, ServerboundTogglePacket::encode, ServerboundTogglePacket::new, ServerboundTogglePacket::handle);
        SNSPacketHandler.register(ServerboundPacketCycleSlotPacket.class, ServerboundPacketCycleSlotPacket::encode, ServerboundPacketCycleSlotPacket::new, ServerboundPacketCycleSlotPacket::handle);
        SNSPacketHandler.register(ServerboundToggleSlotVoidingPacket.class, ServerboundToggleSlotVoidingPacket::encode, ServerboundToggleSlotVoidingPacket::new, ServerboundToggleSlotVoidingPacket::handle);
        SNSPacketHandler.register(ServerboundOpenContainerPacket.class, ServerboundOpenContainerPacket::encode, ServerboundOpenContainerPacket::new, ServerboundOpenContainerPacket::handle);
    }

    private static <T> void register(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, Consumer<T> handler) {
        SNSPacketHandler.register(clazz, encoder, decoder, (T packet, ServerPlayer player) -> handler.accept(packet));
    }

    private static <T> void register(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), clazz, encoder, decoder, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> SNSPacketHandler.lambda$register$2(handler, packet, (Supplier)context));
        });
    }

    private static /* synthetic */ void lambda$register$2(BiConsumer handler, Object packet, Supplier context) {
        handler.accept(packet, ((NetworkEvent.Context)context.get()).getSender());
    }
}

