/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.util;

import mod.traister101.sns.common.capability.ContainerItemHandler;
import mod.traister101.sns.common.capability.LazyCapabilityProvider;
import mod.traister101.sns.common.items.ContainerItem;
import mod.traister101.sns.util.NBTHelper;
import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public interface ContainerType
extends StringRepresentable {
    public static boolean canDoItemPickup(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ContainerItem)) {
            return false;
        }
        ContainerItem containerItem = (ContainerItem)item;
        if (!containerItem.type.doesAutoPickup()) {
            return false;
        }
        return NBTHelper.isAutoPickup(itemStack);
    }

    public static boolean canDoItemVoiding(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ContainerItem)) {
            return false;
        }
        ContainerItem containerItem = (ContainerItem)item;
        return containerItem.type.doesVoiding();
    }

    public int getSlotCount();

    public int getSlotCapacity();

    public boolean doesAutoPickup();

    public boolean doesVoiding();

    public boolean doesInventoryInteraction();

    public Size getAllowedSize();

    public Size getSize(ItemStack var1);

    default public ICapabilityProvider getCapabilityProvider(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return new LazyCapabilityProvider.LazySerializedCapabilityProvider<ContainerItemHandler>(() -> new ContainerItemHandler(this, itemStack), ForgeCapabilities.ITEM_HANDLER);
    }
}

