/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.util.handlers;

import java.util.Optional;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.util.ContainerType;
import mod.traister101.sns.util.SNSUtils;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public final class PickupHandler {
    public static void onPickupItem(EntityItemPickupEvent event) {
        ItemStack itemResult;
        if (!((Boolean)SNSConfig.SERVER.doPickup.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        ItemEntity itemEntity = event.getItem();
        ItemStack entityStack = itemEntity.m_32055_();
        int startCount = entityStack.m_41613_();
        int pickupCount = startCount - (itemResult = PickupHandler.pickupItemStack(player, entityStack)).m_41613_();
        if (0 < pickupCount) {
            player.f_36096_.m_38946_();
            player.m_7938_((Entity)itemEntity, pickupCount);
            if (itemResult.m_41619_()) {
                itemEntity.m_146870_();
            } else {
                itemEntity.m_32045_(itemResult);
            }
            player.m_6278_(Stats.f_12984_.m_12902_((Object)entityStack.m_41720_()), pickupCount);
            player.m_21053_(itemEntity);
        }
        event.setCanceled(itemResult.m_41619_());
        event.setResult(0 < pickupCount ? Event.Result.ALLOW : Event.Result.DEFAULT);
    }

    public static void onGroundBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)SNSConfig.SERVER.doPickup.get()).booleanValue()) {
            return;
        }
        BlockPos blockPos = event.getPos();
        Level level = event.getLevel();
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (!(block instanceof GroundcoverBlock)) {
            return;
        }
        Player player = event.getEntity();
        if (block instanceof LooseRockBlock && player.m_21205_().m_41720_() == block.m_5456_()) {
            return;
        }
        if (block instanceof FallenLeavesBlock) {
            if (player.m_21205_().m_41720_() == block.m_5456_()) {
                return;
            }
            if ((Integer)blockState.m_61143_((Property)FallenLeavesBlock.LAYERS) > 0) {
                return;
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)blockPos, (BlockEntity)level.m_7702_(blockPos), (Entity)player, (ItemStack)ItemStack.f_41583_).forEach(itemStack -> {
                ItemStack itemResult = PickupHandler.pickupItemStack(player, itemStack);
                if (!itemResult.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemResult);
                } else {
                    PickupHandler.playPickupSound((Level)serverLevel, player.m_20182_());
                }
                if (itemResult.m_41613_() != itemStack.m_41613_()) {
                    player.f_36096_.m_38946_();
                }
            });
        }
        level.m_7471_(blockPos, false);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static ItemStack pickupItemStack(Player player, ItemStack itemPickup) {
        ICuriosItemHandler curiosItemHandler;
        IItemHandlerModifiable equippedCurios;
        Optional maybeCuriosItemHandler;
        ItemStack remainder = itemPickup;
        Inventory inventory = player.m_150109_();
        remainder = PickupHandler.topOffPlayerInventory(inventory, remainder);
        if (remainder.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (SNSUtils.isCuriosPresent() && (maybeCuriosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve()).isPresent() && (remainder = PickupHandler.insertItemPickup((IItemHandler)(equippedCurios = (curiosItemHandler = (ICuriosItemHandler)maybeCuriosItemHandler.get()).getEquippedCurios()), remainder, equippedCurios.getSlots())).m_41619_()) {
            return ItemStack.f_41583_;
        }
        remainder = PickupHandler.insertItemPickup((IItemHandler)new PlayerMainInvWrapper(inventory), remainder, 36);
        return remainder;
    }

    private static ItemStack insertItemPickup(IItemHandler itemHandler, ItemStack itemPickup, int slotCount) {
        ItemStack remainder = itemPickup;
        for (int slotIndex = 0; slotIndex < slotCount; ++slotIndex) {
            Optional maybeContainerInv;
            ItemStack itemContainer = itemHandler.getStackInSlot(slotIndex);
            if (!ContainerType.canDoItemPickup(itemContainer) || (maybeContainerInv = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isEmpty() || !(remainder = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)maybeContainerInv.get()), (ItemStack)remainder, (boolean)false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    private static ItemStack topOffPlayerInventory(Inventory inventoryPlayer, ItemStack insertStack) {
        ItemStack remainder = insertStack;
        for (int slotIndex = 0; slotIndex < inventoryPlayer.m_6643_(); ++slotIndex) {
            ItemStack inventoryStack = inventoryPlayer.m_8020_(slotIndex);
            if (inventoryStack.m_41619_() || inventoryStack.m_41613_() >= inventoryStack.m_41741_() || !ItemStack.m_150942_((ItemStack)inventoryStack, (ItemStack)remainder)) continue;
            int remainingSpace = inventoryStack.m_41741_() - inventoryStack.m_41613_();
            if (remainingSpace >= remainder.m_41613_()) {
                inventoryStack.m_41769_(remainder.m_41613_());
                return ItemStack.f_41583_;
            }
            inventoryStack.m_41764_(inventoryStack.m_41741_());
            remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)(remainder.m_41613_() - remainingSpace));
        }
        return remainder;
    }

    private static void playPickupSound(Level level, Vec3 pos) {
        RandomSource rand = level.f_46441_;
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((rand.m_188501_() - rand.m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }
}

