/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.config;

import cn.ussshenzhou.t88.config.TMultiInstanceConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class MultiInstanceConfigHelper {
    private static final File CONFIG_DIR = FMLPaths.CONFIGDIR.relative().toFile();
    private static final ConcurrentHashMap<Class<? extends TMultiInstanceConfig>, ConcurrentHashMap<String, TMultiInstanceConfig>> CACHE = new ConcurrentHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private static void checkDir(File dir) {
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
    }

    private static File checkChildDir(TMultiInstanceConfig config) {
        return MultiInstanceConfigHelper.checkChildDir(config.getClass(), config.getChildDirName());
    }

    private static File checkChildDir(Class<? extends TMultiInstanceConfig> clazz, String childDirName) {
        MultiInstanceConfigHelper.checkDir(CONFIG_DIR);
        MultiInstanceConfigHelper.checkDir(CONFIG_DIR.toPath().resolve(childDirName).toFile());
        File f = CONFIG_DIR.toPath().resolve(childDirName).resolve(clazz.getSimpleName()).toFile();
        MultiInstanceConfigHelper.checkDir(f);
        return f;
    }

    public static void loadConfigInstances(TMultiInstanceConfig newInstance) {
        MultiInstanceConfigHelper.loadConfigInstances(newInstance.getClass(), newInstance.getChildDirName());
    }

    public static void loadConfigInstances(Class<? extends TMultiInstanceConfig> clazz, String childDirName) {
        File childDir = MultiInstanceConfigHelper.checkChildDir(clazz, childDirName);
        File[] instances = childDir.listFiles();
        if (instances == null) {
            return;
        }
        for (File f : instances) {
            try {
                TMultiInstanceConfig instance = (TMultiInstanceConfig)GSON.fromJson(FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8), clazz);
                MultiInstanceConfigHelper.putCache(instance);
                MultiInstanceConfigHelper.saveConfig(instance);
            }
            catch (IOException ignored) {
                LogUtils.getLogger().error("Failed to load config {}. Things may not work well.", (Object)f);
            }
        }
    }

    private static <T extends TMultiInstanceConfig> void putCache(T config) {
        if (CACHE.containsKey(config.getClass())) {
            CACHE.get(config.getClass()).put(config.getFileName(), config);
        } else {
            ConcurrentHashMap<String, T> children = new ConcurrentHashMap<String, T>();
            children.put(config.getFileName(), config);
            CACHE.put(config.getClass(), children);
        }
    }

    public static <T extends TMultiInstanceConfig> ConcurrentHashMap<String, T> getConfigInstancesRead(Class<T> configClass) {
        return CACHE.get(configClass);
    }

    public static <T extends TMultiInstanceConfig> T getConfigInstanceRead(Class<T> configClass, String childName) {
        return (T)CACHE.get(configClass).get(childName);
    }

    public static <T extends TMultiInstanceConfig> void getConfigInstancesWrite(Class<T> configClass, Consumer<ConcurrentHashMap<String, T>> setter) {
        ConcurrentHashMap<String, TMultiInstanceConfig> configInstances = CACHE.get(configClass);
        setter.accept(configInstances);
        configInstances.values().forEach(MultiInstanceConfigHelper::saveConfig);
    }

    public static <T extends TMultiInstanceConfig> void getConfigInstanceWrite(Class<T> configClass, String childName, Consumer<T> setter) {
        TMultiInstanceConfig configInstances = CACHE.get(configClass).get(childName);
        setter.accept(configInstances);
        MultiInstanceConfigHelper.saveConfig(configInstances);
    }

    public static <T extends TMultiInstanceConfig> void addNewConfigInstance(T config) {
        MultiInstanceConfigHelper.putCache(config);
        MultiInstanceConfigHelper.saveConfig(config);
    }

    public static <T extends TMultiInstanceConfig> void removeConfig(T config) {
        CACHE.get(config.getClass()).remove(config.getFileName());
        File configFile = MultiInstanceConfigHelper.checkChildDir(config).toPath().resolve(config.getFileName() + ".json").toFile();
        configFile.delete();
    }

    public static <T extends TMultiInstanceConfig> void saveConfig(T config) {
        File configFile = MultiInstanceConfigHelper.checkChildDir(config).toPath().resolve(config.getFileName() + ".json").toFile();
        Thread.startVirtualThread(() -> {
            try {
                FileUtils.write((File)configFile, (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ignored) {
                LogUtils.getLogger().error("Failed to save config {}. Things may not work well.", config.getClass());
            }
        });
    }
}

