/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.advanced;

import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.util.LayoutHelper;
import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TImage;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class THoverSensitiveImageButton
extends TPanel {
    protected TImage backgroundImage;
    protected TImage backgroundImageHovered;
    protected TButton button;
    protected TLabel text;
    protected int padding = 0;
    private boolean inTransition = false;
    private boolean transited = false;
    private int transitionTimeMinus1 = 2;
    private float transitionTick = 0.0f;

    public THoverSensitiveImageButton(Component text1, Button.OnPress onPress, @Nullable ResourceLocation backgroundImageLocation, @Nullable ResourceLocation backgroundImageLocationHovered) {
        if (backgroundImageLocation == null) {
            backgroundImageLocation = PLACEHOLDER_IMAGE;
        }
        if (backgroundImageLocationHovered == null) {
            backgroundImageLocationHovered = PLACEHOLDER_IMAGE;
        }
        this.text = new TLabel(text1);
        this.text.setAutoScroll(false).setHorizontalAlignment(HorizontalAlignment.CENTER);
        this.button = new TButton(this, (Component)Component.literal((String)""), onPress){

            @Override
            public void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            }
        };
        this.backgroundImageHovered = new TImage(backgroundImageLocationHovered);
        this.backgroundImageHovered.setVisibleT(false);
        this.add(this.backgroundImageHovered);
        this.backgroundImage = new TImage(backgroundImageLocation);
        this.add(this.backgroundImage);
        this.add(this.button);
        this.add(this.text);
    }

    @Override
    public void layout() {
        this.backgroundImage.setBounds(this.padding, this.padding, this.width - this.padding * 2, this.height - this.padding * 2);
        this.backgroundImageHovered.setBounds(0, 0, this.getSize());
        LayoutHelper.BSameAsA(this.text, this.backgroundImage);
        this.button.setBounds(this.padding / 2, this.padding / 2, this.width - this.padding, this.height - this.padding);
        super.layout();
    }

    @Override
    public void tickT() {
        if (this.button.isHoveredOrFocused()) {
            this.backgroundImage.setVisibleT(false);
            this.backgroundImageHovered.setVisibleT(true);
        } else {
            this.backgroundImage.setVisibleT(true);
            this.backgroundImageHovered.setVisibleT(false);
        }
        if (this.backgroundImageHovered.isVisibleT() && !this.transited) {
            if (!this.inTransition) {
                this.inTransition = true;
            }
            if (this.transitionTick >= (float)this.transitionTimeMinus1) {
                this.inTransition = false;
                this.transited = true;
                this.transitionTick = 0.0f;
            }
        }
        if (!this.backgroundImageHovered.isVisibleT()) {
            this.inTransition = false;
            this.transited = false;
            this.transitionTick = 0.0f;
        }
        super.tickT();
    }

    @Override
    protected void renderChildren(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (TWidget tWidget : this.children) {
            if (!tWidget.isVisibleT()) continue;
            graphics.pose().translate(0.0f, 0.0f);
            if (tWidget == this.text && this.backgroundImageHovered.isVisibleT()) {
                this.renderText(graphics, pMouseX, pMouseY, pPartialTick);
                continue;
            }
            if (tWidget == this.backgroundImageHovered) {
                this.renderBgImageHovered(graphics, pMouseX, pMouseY, pPartialTick);
                continue;
            }
            tWidget.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    protected void renderBgImageHovered(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.padding != 0 && this.inTransition && this.transitionTick < (float)this.transitionTimeMinus1) {
            float minScaleX = (float)this.backgroundImage.getWidth() / (float)this.backgroundImageHovered.getWidth();
            float minScaleY = (float)this.backgroundImage.getHeight() / (float)this.backgroundImageHovered.getHeight();
            float scaleX = minScaleX + this.transitionTick / (float)this.transitionTimeMinus1 * (1.0f - minScaleX);
            float scaleY = minScaleY + this.transitionTick / (float)this.transitionTimeMinus1 * (1.0f - minScaleY);
            float compensationRelativeX = (1.0f - scaleX) / (1.0f - minScaleX) * (float)this.padding;
            float compensationRelativeY = (1.0f - scaleY) / (1.0f - minScaleY) * (float)this.padding;
            graphics.pose().pushMatrix();
            graphics.pose().translate((1.0f - scaleX) * (float)this.backgroundImageHovered.getXT() + compensationRelativeX, (1.0f - scaleY) * (float)this.backgroundImageHovered.getYT() + compensationRelativeY);
            graphics.pose().scale(scaleX, scaleY);
            this.backgroundImageHovered.render(graphics, pMouseX, pMouseY, pPartialTick);
            graphics.pose().popMatrix();
            this.transitionTick += pPartialTick;
        } else {
            this.backgroundImageHovered.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    protected void renderText(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        float maxScaleX = (float)this.backgroundImageHovered.getWidth() / (float)this.backgroundImage.getWidth();
        float maxScaleY = (float)this.backgroundImageHovered.getHeight() / (float)this.backgroundImage.getHeight();
        float maxScale = Math.min(maxScaleX, maxScaleY);
        if (this.padding != 0 && this.inTransition && this.transitionTick < (float)this.transitionTimeMinus1) {
            float scale = 1.0f + this.transitionTick / (float)this.transitionTimeMinus1 * (maxScale - 1.0f);
            this.renderTextInternal(graphics, pMouseX, pMouseY, pPartialTick, scale, maxScale);
        } else {
            this.renderTextInternal(graphics, pMouseX, pMouseY, pPartialTick, maxScale, maxScale);
        }
    }

    public void renderTextInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick, float scale, float maxScale) {
        float compensationRelative = this.padding == 0 ? 0.0f : (1.0f - scale) / (maxScale - 1.0f) * (float)this.padding;
        graphics.pose().pushMatrix();
        graphics.pose().translate((1.0f - scale) * (float)this.text.getXT() + compensationRelative, (1.0f - scale) * (float)this.text.getYT() + compensationRelative);
        graphics.pose().scale(scale, scale);
        this.text.render(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.pose().popMatrix();
    }

    public TImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public TImage getBackgroundImageHovered() {
        return this.backgroundImageHovered;
    }

    public TButton getButton() {
        return this.button;
    }

    public TLabel getText() {
        return this.text;
    }

    public int getPadding() {
        return this.padding;
    }

    public THoverSensitiveImageButton setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getTransitionTimeMinus1() {
        return this.transitionTimeMinus1;
    }

    public THoverSensitiveImageButton setTransitionTimeMinus1(int transitionTimeMinus1) {
        this.transitionTimeMinus1 = transitionTimeMinus1;
        return this;
    }
}

