/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.advanced;

import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.util.ColorManager;
import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TImage;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TImageButton
extends TImage {
    protected TButton button;
    protected int normalBorder = ColorManager.get().defaultBackground();
    protected int hoverBorder = ColorManager.get().themeColor();

    public TImageButton(ResourceLocation imageLocation, Button.OnPress onPress) {
        super(imageLocation);
        this.button = new TButton((Component)Component.empty(), onPress);
        this.button.setSkipRenderAsBackend(true);
        this.add(this.button);
        this.setBorder(new Border(this.normalBorder, -1));
    }

    public TImageButton(ResourceLocation imageLocation, Button.OnPress onPress, int normalBorder, int hoverBorder) {
        this(imageLocation, onPress);
        this.normalBorder = normalBorder;
        this.hoverBorder = hoverBorder;
    }

    public void setOnPress(Button.OnPress onPress) {
        this.button.setOnPress(onPress);
    }

    public void onPress() {
        this.button.onPress();
    }

    @Override
    public void layout() {
        this.button.setBounds(0, 0, this.width, this.height);
        super.layout();
    }

    @Override
    public void tickT() {
        if (this.button.isHoveredOrFocused()) {
            this.setBorder(new Border(this.hoverBorder, -1));
        } else {
            this.setBorder(new Border(this.normalBorder, -1));
        }
        super.tickT();
    }

    public int getNormalBorder() {
        return this.normalBorder;
    }

    public void setNormalBorder(int normalBorder) {
        this.normalBorder = normalBorder;
    }

    public int getHoverBorder() {
        return this.hoverBorder;
    }

    public void setHoverBorder(int hoverBorder) {
        this.hoverBorder = hoverBorder;
    }

    public TButton getButton() {
        return this.button;
    }
}

