/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.container;

import cn.ussshenzhou.t88.gui.advanced.TLabelButton;
import cn.ussshenzhou.t88.gui.container.TVerticalScrollContainer;
import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.util.LayoutHelper;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.joml.Vector2i;

public class TTabPageContainer
extends TPanel {
    protected TabContainerVertical container = new TabContainerVertical();
    private Tab selectedTab = null;

    public TTabPageContainer() {
        this.add(this.container);
    }

    @Override
    public void tickT() {
        if (this.getSelectedTab() == null && !this.container.tabs.isEmpty()) {
            this.selectTab(0);
        }
        super.tickT();
    }

    @Override
    public void layout() {
        this.container.setBounds(0, 0, this.width, Math.min(this.height / 2, this.container.getPreferredSize().y));
        this.container.tabs.forEach(tab -> LayoutHelper.BBottomOfA(tab.content, 1, this.container, this.width, this.height - 1 - this.container.getHeight()));
        super.layout();
    }

    public Tab newTab(Component c, TWidget content) {
        Tab tab = this.container.newTab(c, content);
        content.setVisibleT(false);
        this.add(content);
        this.layout();
        return tab;
    }

    public void selectTab(Tab tab) {
        this.container.tabs.forEach(t -> {
            t.content.setVisibleT(false);
            t.setSelect(false);
        });
        tab.content.setVisibleT(true);
        tab.setSelect(true);
        this.selectedTab = tab;
    }

    public void selectTab(int index) {
        this.selectTab(this.container.tabs.get(index));
    }

    public void removeTab(Tab tab) {
        int next = this.container.tabs.indexOf(tab);
        this.remove(tab.content);
        this.container.remove(tab);
        this.container.tabs.remove(tab);
        if (this.selectedTab == tab) {
            this.selectedTab = null;
        }
        this.layout();
        if (this.container.tabs.isEmpty()) {
            return;
        }
        if (next == this.container.tabs.size()) {
            --next;
        }
        this.selectTab(next);
    }

    @Nullable
    public Tab getSelectedTab() {
        return this.selectedTab;
    }

    public ImmutableList<Tab> getTabs() {
        return ImmutableList.copyOf(this.container.tabs);
    }

    public class TabContainerVertical
    extends TVerticalScrollContainer {
        protected LinkedList<Tab> tabs = new LinkedList();
        int row = 0;

        public TabContainerVertical() {
            this.bottomMargin = 0;
        }

        private Tab newTab(Component c, TWidget content) {
            Tab tab = new Tab(c, content);
            this.add(tab);
            this.tabs.add(tab);
            return tab;
        }

        protected void rearrangeTabs() {
            ArrayList<Tab> tmp = new ArrayList<Tab>();
            Iterator iterator = this.tabs.iterator();
            while (iterator.hasNext()) {
                Tab tab = (Tab)iterator.next();
                if (!tab.keepFinal) continue;
                iterator.remove();
                tmp.add(tab);
            }
            this.tabs.addAll(tmp);
        }

        @Override
        public void layout() {
            this.rearrangeTabs();
            int prevRow = this.row;
            this.row = 0;
            boolean newRow = false;
            for (int i = 0; i < this.tabs.size(); ++i) {
                Tab tab = this.tabs.get(i);
                Vector2i size = tab.getPreferredSize();
                if (i == 0) {
                    tab.setBounds(0, 0, Math.min(size.x, this.getUsableWidth()), size.y);
                    continue;
                }
                if (newRow) {
                    tab.setBounds(0, this.row * size.y, Math.min(size.x, this.getUsableWidth()), size.y);
                    newRow = false;
                    continue;
                }
                LayoutHelper.BRightOfA(tab, 0, this.tabs.get(i - 1), size);
                if (tab.getXT() + tab.getWidth() <= this.getXT() + this.getUsableWidth()) continue;
                newRow = true;
                ++this.row;
                --i;
            }
            if (this.row != prevRow && this.getParent() != null) {
                this.getParent().layout();
            }
            super.layout();
        }

        @Override
        public Vector2i getPreferredSize() {
            return new Vector2i(0, (this.row + 1) * 14);
        }
    }

    public class Tab
    extends TLabelButton {
        protected final TLabelButton close;
        protected TWidget content;
        protected static final int HEIGHT = 14;
        protected boolean closeable;
        protected boolean keepFinal;

        public Tab(Component c, TWidget content) {
            super(c);
            this.closeable = true;
            this.keepFinal = false;
            this.button.setOnPress(pButton -> TTabPageContainer.this.selectTab(this));
            this.close = new TLabelButton((Component)Component.literal((String)"\u00d7"), pButton -> TTabPageContainer.this.removeTab(this));
            this.close.setBorder(null);
            this.close.setForeground(-4473925);
            this.add(this.close);
            this.content = content;
        }

        public void setSelect(boolean select) {
            this.setBorder(new Border(select ? -12807681 : -1, -1));
        }

        @Override
        public void tickT() {
            if (this.close.getButton().isHoveredOrFocused()) {
                this.close.setBackground(this.close.getHoverBackGround());
                this.setBackground(this.normalBackGround);
            } else {
                this.close.setBackground(this.close.getNormalBackGround());
                if (this.button.isHoveredOrFocused()) {
                    this.setBackground(this.hoverBackGround);
                } else {
                    this.setBackground(this.normalBackGround);
                }
            }
            this.tickChildren();
        }

        @Override
        public void layout() {
            this.close.setBounds(this.width - 12, 0, 12, 14);
            super.layout();
        }

        public Tab setCloseable(boolean closeable) {
            this.closeable = closeable;
            this.close.setVisibleT(closeable);
            this.close.getButton().setVisibleT(closeable);
            return this;
        }

        public Tab setKeepFinal(boolean keepFinal) {
            this.keepFinal = keepFinal;
            this.getParentInstanceOf(TTabPageContainer.class).layout();
            return this;
        }

        public TLabelButton getCloseButton() {
            return this.close;
        }

        public TWidget getContent() {
            return this.content;
        }

        @Override
        public Vector2i getPreferredSize() {
            return new Vector2i(super.getPreferredSize().x + 28 + 2, 14);
        }

        @Override
        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            return this.close.mouseClicked(pMouseX, pMouseY, pButton) || super.mouseClicked(pMouseX, pMouseY, pButton);
        }
    }
}

