/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.container;

import cn.ussshenzhou.t88.gui.container.TScrollContainer;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class TVerticalAndHorizontalScrollContainer
extends TPanel
implements TScrollContainer {
    protected double scrollAmountX = 0.0;
    protected double scrollAmountY = 0.0;
    protected double prevScrollAmountX = 0.0;
    protected double prevScrollAmountY = 0.0;
    protected int bottomX = 0;
    protected int bottomY = 0;
    protected boolean showScrollBarVertical = true;
    protected boolean showScrollBarHorizontal = true;
    protected static int speedFactor = 12;
    protected int scrollbarGap = 0;
    protected int bottomMargin = 5;
    public static final int SCROLL_BAR_WIDTH = 6;
    public static final ResourceLocation SCROLLER_VERTICAL = ResourceLocation.fromNamespaceAndPath((String)"t88", (String)"scroller_v");
    public static final ResourceLocation SCROLLER_HORIZONTAL = ResourceLocation.fromNamespaceAndPath((String)"t88", (String)"scroller_h");

    public TVerticalAndHorizontalScrollContainer() {
        this.setBackground(Integer.MIN_VALUE);
    }

    @Override
    public void layout() {
        this.initPos();
        super.layout();
    }

    protected void initPos() {
        this.bottomY = 0;
        this.bottomX = 0;
        for (TWidget tWidget : this.children) {
            int y;
            Vector2i size = tWidget.getSize();
            int x = tWidget.getXT() + size.x;
            if (this.bottomX < x) {
                this.bottomX = x;
            }
            if (this.bottomY >= (y = tWidget.getYT() + size.y)) continue;
            this.bottomY = y;
        }
        this.bottomX += this.bottomMargin;
        this.bottomY += this.bottomMargin;
    }

    @Override
    public void tickT() {
        this.prevScrollAmountX = this.scrollAmountX;
        this.prevScrollAmountY = this.scrollAmountY;
        super.tickT();
    }

    @Override
    public void render(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isScrollBarVisibleVertical()) {
            this.renderVerticalScrollBar(guigraphics);
        }
        if (this.isScrollBarVisibleHorizontal()) {
            this.renderHorizontalScrollBar(guigraphics);
        }
        super.render(guigraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected void renderChildren(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Vector2d scroll = this.getParentScroll();
        guigraphics.enableScissor((int)((double)this.x - scroll.x), (int)((double)this.y - scroll.y), (int)((double)(this.x + this.getUsableWidth()) - scroll.x), (int)((double)(this.y + this.getUsableHeight()) - scroll.y));
        this.prepareTranslate(guigraphics, pPartialTick);
        super.renderChildren(guigraphics, pMouseX, pMouseY, pPartialTick);
        this.endTranslate(guigraphics, pPartialTick);
        guigraphics.disableScissor();
    }

    @Override
    public void renderTop(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.prepareTranslate(guigraphics, pPartialTick);
        super.renderTop(guigraphics, pMouseX, pMouseY, pPartialTick);
        this.endTranslate(guigraphics, pPartialTick);
    }

    protected void prepareTranslate(GuiGraphics guigraphics, float pPartialTick) {
        guigraphics.pose().translate((float)Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmountX), (double)(-this.scrollAmountX)), (float)Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmountY), (double)(-this.scrollAmountY)));
    }

    protected void endTranslate(GuiGraphics guigraphics, float pPartialTick) {
        guigraphics.pose().translate((float)(-Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmountX), (double)(-this.scrollAmountX))), (float)(-Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmountY), (double)(-this.scrollAmountY))));
    }

    @Override
    protected void renderBackground(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        guigraphics.fill(this.x, this.y, this.x + this.width - (this.isScrollBarVisibleVertical() ? this.getScrollbarGap() + 6 : 0), this.y + this.height - (this.isScrollBarVisibleHorizontal() ? this.getScrollbarGap() + 6 : 0), this.background);
    }

    protected ResourceLocation getScrollerVerticalTexture() {
        return SCROLLER_VERTICAL;
    }

    protected ResourceLocation getScrollerHorizontalTexture() {
        return SCROLLER_HORIZONTAL;
    }

    protected void renderVerticalScrollBar(GuiGraphics guiGraphics) {
        int x1 = this.getScrollBarVerticalX();
        int k = (int)((float)(this.height * this.height) / (float)this.bottomY);
        int l = (int)this.getScroll().y * (this.height - (k = Mth.clamp((int)k, (int)32, (int)(this.height - 8)))) / this.getMaxScrollY() + this.getYT();
        if (l < this.getYT()) {
            l = this.getYT();
        }
        guiGraphics.fill(x1, this.getYT(), x1 + 6, this.getYT() + this.height, Integer.MIN_VALUE);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getScrollerVerticalTexture(), x1, l, 6, k);
    }

    protected void renderHorizontalScrollBar(GuiGraphics guiGraphics) {
        int y1 = this.getScrollBarVerticalY();
        int w = this.getUsableWidth();
        int k = (int)((float)(w * w) / (float)this.bottomX);
        int l = (int)this.getScroll().x * (w - (k = Mth.clamp((int)k, (int)32, (int)(w - 8)))) / this.getMaxScrollX() + this.getXT();
        if (l < this.getXT()) {
            l = this.getXT();
        }
        guiGraphics.fill(this.getXT(), y1, this.getXT() + w, y1 + 6, Integer.MIN_VALUE);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getScrollerHorizontalTexture(), l, y1, k, 6);
    }

    protected int getScrollBarVerticalX() {
        return this.getXT() + this.width - 6;
    }

    protected int getScrollBarVerticalY() {
        return this.getYT() + this.height - 6;
    }

    public int getUsableWidth() {
        return this.width - 6 - this.scrollbarGap;
    }

    public int getUsableHeight() {
        return this.height - 6 - this.scrollbarGap;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.isInRange(pMouseX, pMouseY, this.scrollbarGap, this.scrollbarGap)) {
            double d1;
            int j;
            for (TWidget tWidget : this.children) {
                if (!tWidget.mouseDragged(pMouseX + this.scrollAmountX, pMouseY + this.scrollAmountY, pButton, pDragX, pDragY)) continue;
                return true;
            }
            if (pMouseX > (double)(this.getScrollBarVerticalX() - this.scrollbarGap - 6)) {
                double d0 = Math.max(1, this.getMaxScrollY());
                j = Mth.clamp((int)((int)((float)(this.height * this.height) / (float)this.bottomY)), (int)32, (int)this.height);
                d1 = Math.max(1.0, d0 / (double)(this.height - j));
                this.addScrollAmountY(-pDragY * d1 / (double)speedFactor);
            } else {
                this.addScrollAmountY(pDragY / (double)speedFactor);
            }
            if (pMouseY > (double)(this.getScrollBarVerticalY() - this.scrollbarGap - 6)) {
                double d0 = Math.max(1, this.getMaxScrollX());
                j = Mth.clamp((int)((int)((float)(this.width * this.width) / (float)this.bottomX)), (int)32, (int)this.width);
                d1 = Math.max(1.0, d0 / (double)(this.width - j));
                this.addScrollAmountX(-pDragX * d1 / (double)speedFactor);
            } else {
                this.addScrollAmountX(pDragX / (double)speedFactor);
            }
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (this.isInRange(pMouseX, pMouseY) && !super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY)) {
            this.addScrollAmountY(deltaY);
            this.addScrollAmountX(deltaX);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseClicked(pMouseX + this.scrollAmountX, pMouseY + this.scrollAmountY, pButton);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseReleased(pMouseX + this.scrollAmountX, pMouseY + this.scrollAmountY, pButton);
        }
        return false;
    }

    protected boolean isScrollBarVisibleVertical() {
        return this.getMaxScrollY() > 0 && this.showScrollBarVertical;
    }

    protected boolean isScrollBarVisibleHorizontal() {
        return this.getMaxScrollX() > 0 && this.showScrollBarHorizontal;
    }

    protected int getMaxScrollY() {
        return Math.max(0, this.bottomY - this.getYT() - this.getHeight());
    }

    protected int getMaxScrollX() {
        return Math.max(0, this.bottomX - this.getXT() - this.getWidth());
    }

    @Override
    public Vector2d getScroll() {
        return new Vector2d(this.scrollAmountX, this.scrollAmountY);
    }

    public void addScrollAmountY(double deltaScroll) {
        double result = Mth.clamp((double)(this.scrollAmountY + (deltaScroll = -deltaScroll * (double)speedFactor)), (double)0.0, (double)this.getMaxScrollY());
        if (Double.isNaN(result)) {
            return;
        }
        this.scrollAmountY = result;
    }

    public void addScrollAmountX(double deltaScroll) {
        double result = Mth.clamp((double)(this.scrollAmountX + (deltaScroll = -deltaScroll * (double)speedFactor)), (double)0.0, (double)this.getMaxScrollX());
        if (Double.isNaN(result)) {
            return;
        }
        this.scrollAmountX = result;
    }

    public int getScrollbarGap() {
        return this.scrollbarGap;
    }

    public void setScrollbarGap(int scrollbarGap) {
        this.scrollbarGap = scrollbarGap;
    }

    public boolean isShowScrollBarVertical() {
        return this.showScrollBarVertical;
    }

    public void setShowScrollBarVertical(boolean showScrollBarVertical) {
        this.showScrollBarVertical = showScrollBarVertical;
    }

    public boolean isShowScrollBarHorizontal() {
        return this.showScrollBarHorizontal;
    }

    public void setShowScrollBarHorizontal(boolean showScrollBarHorizontal) {
        this.showScrollBarHorizontal = showScrollBarHorizontal;
    }

    public static int getSpeedFactor() {
        return speedFactor;
    }

    public static void setSpeedFactor(int speedFactor) {
        TVerticalAndHorizontalScrollContainer.speedFactor = speedFactor;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setScrollAmountXDirectly(double scrollAmountX) {
        this.prevScrollAmountX = this.scrollAmountX;
        this.scrollAmountX = scrollAmountX;
    }

    public void setScrollAmountYDirectly(double scrollAmountY) {
        this.prevScrollAmountY = this.scrollAmountY;
        this.scrollAmountY = scrollAmountY;
    }
}

