/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.screen;

import cn.ussshenzhou.t88.gui.event.ClearEditBoxFocusEvent;
import cn.ussshenzhou.t88.gui.widegt.TComponent;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.common.NeoForge;

public abstract class TScreen
extends Screen {
    protected boolean needRelayout = true;
    protected LinkedList<TWidget> tChildren = new LinkedList();

    public TScreen(Component pTitle) {
        super(pTitle);
        this.minecraft = Minecraft.getInstance();
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.resize(pMinecraft, pWidth, pHeight);
        this.needRelayout = true;
    }

    public void tick() {
        if (this.needRelayout) {
            this.layout();
            this.needRelayout = false;
        }
        for (TWidget child : this.tChildren) {
            child.tickT();
        }
        super.tick();
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.pose().pushMatrix();
        for (TWidget w : this.tChildren) {
            if (!w.isVisibleT()) continue;
            w.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        for (TWidget w : this.tChildren) {
            if (!w.isVisibleT()) continue;
            w.renderTop(graphics, pMouseX, pMouseY, pPartialTick);
        }
        graphics.pose().pushMatrix();
    }

    public void add(TWidget tWidget) {
        this.tChildren.add(tWidget);
        tWidget.setParentScreen(this);
    }

    public void addAll(TWidget ... children) {
        Stream.of(children).forEach(this::add);
    }

    public void addAll(Collection<TWidget> children) {
        children.forEach(this::add);
    }

    public void remove(TWidget tWidget) {
        this.tChildren.remove(tWidget);
        tWidget.setParentScreen(null);
    }

    public void layout() {
        for (TWidget w : this.tChildren) {
            if (!(w instanceof TComponent)) continue;
            TComponent t = (TComponent)w;
            t.layout();
        }
    }

    public static <T> Iterable<T> reversed(final List<T> list) {
        return () -> new Iterator<T>(){
            private final ListIterator<T> iter;
            {
                this.iter = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasPrevious();
            }

            @Override
            public T next() {
                return this.iter.previous();
            }
        };
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        NeoForge.EVENT_BUS.post((Event)new ClearEditBoxFocusEvent(pMouseX, pMouseY));
        for (TWidget tWidget : TScreen.reversed(this.tChildren)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            this.setFocused(tWidget);
            if (pButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.setDragging(false);
        for (TWidget tWidget : TScreen.reversed(this.tChildren)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseReleased(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        for (TWidget tWidget : TScreen.reversed(this.tChildren)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        for (TWidget tWidget : TScreen.reversed(this.tChildren)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose(true);
            return true;
        }
        return this.getFocused() != null && this.getFocused().keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return this.getFocused() != null && this.getFocused().keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.getFocused() != null && this.getFocused().charTyped(pCodePoint, pModifiers);
    }

    @Deprecated
    public void onClose() {
        this.onClose(true);
    }

    public void onClose(boolean isFinal) {
        if (isFinal) {
            TScreen.reversed(this.tChildren).forEach(TWidget::onFinalClose);
        }
        ClientHooks.popGuiLayer((Minecraft)Minecraft.getInstance());
    }
}

