/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.util.ImageFit;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class TImage
extends TPanel {
    protected ResourceLocation imageLocation;
    protected ImageFit imageFit = ImageFit.FILL;
    protected int imageWidth;
    protected int imageHeight;
    protected float scale = 1.0f;
    protected float alpha = 1.0f;

    public TImage(ResourceLocation imageLocation) {
        this.imageLocation = imageLocation;
        this.loadImageWH();
    }

    public TImage(String imageLocation) {
        this(ResourceLocation.parse((String)imageLocation));
    }

    public TImage(String namespace, String imageLocation) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)imageLocation));
    }

    public ImageFit getImageFit() {
        return this.imageFit;
    }

    public void setImageFit(ImageFit imageFit) {
        this.imageFit = imageFit;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public ResourceLocation getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(ResourceLocation imageLocation) {
        if (this.imageLocation.equals((Object)imageLocation)) {
            return;
        }
        this.imageLocation = imageLocation;
        this.loadImageWH();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    protected void loadImageWH() {
        try (NativeImage n = NativeImage.read((InputStream)((Resource)Minecraft.getInstance().getResourceManager().getResource(this.imageLocation).get()).open());){
            this.imageWidth = n.getWidth();
            this.imageHeight = n.getHeight();
        }
        catch (IOException | NoSuchElementException e) {
            LogUtils.getLogger().error("Failed to get width and height of {}.", (Object)this.imageLocation.getPath());
            LogUtils.getLogger().error(e.getMessage());
            this.imageLocation = null;
        }
    }

    @Override
    public void render(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.imageLocation != null) {
            int color = (int)this.alpha * 255 << 24 | 0xFFFFFF;
            switch (this.imageFit) {
                case FILL: {
                    float panelWHRatio = (float)this.width / (float)this.height;
                    float imageWHRatio = (float)this.imageWidth / (float)this.imageHeight;
                    if (panelWHRatio > imageWHRatio) {
                        guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, this.x, this.y, 0.0f, (float)((int)(((float)this.imageHeight - (float)this.imageWidth / panelWHRatio) / 2.0f)), this.width, this.height, this.imageWidth, (int)((float)this.imageWidth / panelWHRatio), (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale), color);
                        break;
                    }
                    guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, this.x, this.y, (float)((int)(((float)this.imageWidth - (float)this.imageHeight * panelWHRatio) / 2.0f)), 0.0f, this.width, this.height, (int)((float)this.imageHeight * panelWHRatio), this.imageHeight, (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale), color);
                    break;
                }
                case FIT: {
                    float panelWHRatio = (float)this.width / (float)this.height;
                    float imageWHRatio = (float)this.imageWidth / (float)this.imageHeight;
                    if (panelWHRatio > imageWHRatio) {
                        guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, (int)((float)this.x + ((float)this.width - (float)this.height * imageWHRatio) / 2.0f), this.y, 0.0f, 0.0f, (int)((float)this.height * imageWHRatio), this.height, this.imageWidth, this.imageHeight, (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale), color);
                        break;
                    }
                    guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, this.x, (int)((float)this.y + ((float)this.height - (float)this.width / imageWHRatio) / 2.0f), 0.0f, 0.0f, this.width, (int)((float)this.width / imageWHRatio), this.imageWidth, this.imageHeight, (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale), color);
                    break;
                }
                case STRETCH: {
                    guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.imageWidth, this.imageHeight, (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale));
                    break;
                }
                case TILE: {
                    guigraphics.blit(RenderPipelines.GUI_TEXTURED, this.imageLocation, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height, (int)((float)this.imageWidth * this.scale), (int)((float)this.imageHeight * this.scale));
                }
            }
        }
        super.render(guigraphics, pMouseX, pMouseY, pPartialTick);
    }
}

