/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector2i;

public class TItem
extends TPanel {
    public static int DEFAULT_SIZE = 16;
    private LivingEntity host;
    private ItemStack item;
    private float itemSize;
    private final TLabel count;
    private boolean showTooltip = false;

    public TItem(ItemStack item, LivingEntity host, float itemSize) {
        this.host = host;
        this.item = item;
        this.itemSize = itemSize;
        this.count = new TLabel((Component)Component.literal((String)String.valueOf(item.getCount()))).setHorizontalAlignment(HorizontalAlignment.RIGHT).setFontSize(itemSize / (float)DEFAULT_SIZE * 7.0f).setAutoScroll(false);
        this.add(this.count);
        if (item.getCount() <= 1) {
            this.count.setVisibleT(false);
        }
        this.count.setAutoScroll(false);
    }

    public TItem(ItemStack item) {
        this(item, null, DEFAULT_SIZE);
    }

    public TItem(Item item) {
        this(new ItemStack((ItemLike)item));
    }

    @Override
    public void layout() {
        this.count.setBounds(0, (int)((float)this.height - this.itemSize / (float)DEFAULT_SIZE * 7.0f), this.width, (int)(this.itemSize / (float)DEFAULT_SIZE * 7.0f));
        super.layout();
    }

    @Override
    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.pose().pushMatrix();
        this.renderItem(graphics, pMouseX, pMouseY, pPartialTick);
        float scale = this.itemSize / (float)DEFAULT_SIZE;
        if (this.count.isVisibleT()) {
            this.count.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        if (this.showTooltip && this.isInRange(pMouseX, pMouseY) && this.getTopParentScreen() != null) {
            graphics.disableScissor();
            graphics.setTooltipForNextFrame(Minecraft.getInstance().font, Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.item), this.item.getTooltipImage(), this.item, this.x, this.y, (ResourceLocation)this.item.get(DataComponents.TOOLTIP_STYLE));
            ScreenRectangle rectangle = (ScreenRectangle)graphics.scissorStack.stack.peek();
            if (rectangle != null) {
                Window window = Minecraft.getInstance().getWindow();
                int i = window.getHeight();
                double d0 = window.getGuiScale();
                double d1 = (double)rectangle.left() * d0;
                double d2 = (double)i - (double)rectangle.bottom() * d0;
                double d3 = (double)rectangle.width() * d0;
                double d4 = (double)rectangle.height() * d0;
                graphics.enableScissor((int)d1, (int)d2, Math.max(0, (int)d3), Math.max(0, (int)d4));
            }
        }
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.pose().popMatrix();
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.item.isEmpty()) {
            return;
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.x, (float)this.y);
        graphics.pose().scale(this.itemSize / (float)DEFAULT_SIZE);
        graphics.renderItem(this.item, 0, 0);
        graphics.pose().popMatrix();
    }

    @Override
    public Vector2i getPreferredSize() {
        return new Vector2i((int)((float)DEFAULT_SIZE * this.itemSize / 16.0f), (int)((float)DEFAULT_SIZE * this.itemSize / 16.0f));
    }

    public LivingEntity getHost() {
        return this.host;
    }

    public void setHost(LivingEntity host) {
        this.host = host;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public TItem setItem(ItemStack item) {
        this.item = item;
        this.count.setText((Component)Component.literal((String)String.valueOf(item.getCount())));
        if (item.getCount() <= 1) {
            this.count.setVisibleT(false);
        }
        return this;
    }

    public float getItemSize() {
        return this.itemSize;
    }

    public TItem setItemSize(float size) {
        this.itemSize = size;
        this.count.setFontSize(this.itemSize / (float)DEFAULT_SIZE * 7.0f);
        this.layout();
        return this;
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public TItem setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        return this;
    }
}

