/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.util.ColorManager;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import org.joml.Vector2d;

public class TProgressBar
extends TLabel {
    protected String prefix = "";
    protected double maxValue = 1.0;
    protected double value = 0.0;
    protected TextMode textMode = TextMode.NONE;
    protected int progressBarColor0 = ColorManager.get().themeColor();
    protected int progressBarColor1 = ColorManager.get().themeColor();

    public TProgressBar() {
        this("", 1.0);
    }

    public TProgressBar(double maxValue) {
        this("", maxValue);
    }

    public TProgressBar(String prefix, double maxValue) {
        this.prefix = prefix;
        this.maxValue = maxValue;
        this.background = ColorManager.get().defaultBackground();
        this.setHorizontalAlignment(HorizontalAlignment.CENTER);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void increaseValue(double value) {
        this.value += value;
    }

    public void setTextMode(TextMode textMode) {
        this.textMode = textMode;
    }

    public void setProgressBarColor(int progressBarColor) {
        this.progressBarColor0 = progressBarColor;
        this.progressBarColor1 = progressBarColor;
    }

    public void setProgressBarColorGradient(int color0, int color1) {
        this.progressBarColor0 = color0;
        this.progressBarColor1 = color1;
    }

    @Override
    public void tickT() {
        this.setText((Component)Component.literal((String)this.textMode.generator.get(this.prefix, this.maxValue, this.value)));
        super.tickT();
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.background);
        int dx = (int)((double)this.width * this.value / this.maxValue);
        Vector2d scroll = this.getParentScroll();
        graphics.scissorStack.push(new ScreenRectangle((int)(scroll.x + (double)this.x), (int)((double)this.y - scroll.y), dx, this.height));
        this.fillGradientHorizontal(graphics, this.x, this.y, this.x + this.width, this.y + this.height, this.progressBarColor0, this.progressBarColor1);
        graphics.scissorStack.pop();
    }

    public static class TextMode {
        public static final TextMode NONE = new TextMode((pre, max, v) -> "");
        public static final TextMode PREFIX_ONLY = new TextMode((pre, max, v) -> pre);
        public static final TextMode VALUE_FLOAT = new TextMode((pre, max, v) -> pre + String.format("%.2f", v));
        public static final TextMode VALUE_FLOAT_SLASH_MAX = new TextMode((pre, max, v) -> pre + String.format("%.2f/%.2f", v, max));
        public static final TextMode VALUE_INT = new TextMode((pre, max, v) -> pre + String.format("%d", (int)v));
        public static final TextMode VALUE_INT_SLASH_MAX = new TextMode((pre, max, v) -> pre + String.format("%d/%d", (int)v, (int)max));
        public static final TextMode PERCENTAGE = new TextMode((pre, max, v) -> {
            if (Math.abs(v - 1.0) <= 1.0E-6) {
                return pre + String.format("%.1f", 100.0 * v) + "%";
            }
            return pre + String.format("%.1f", 100.0 * v / max) + "%";
        });
        private final TextGenerator generator;

        public TextMode(TextGenerator generator) {
            this.generator = generator;
        }
    }

    @FunctionalInterface
    public static interface TextGenerator {
        public String get(String var1, double var2, double var4);
    }
}

