/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.event.TimerCountdownReachEvent;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import com.mafuyu33.mafishcrossbow.mixin.t88.MutableComponentAccessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TTimer
extends TLabel {
    private long startMs = 0L;
    private long pausedMs = 0L;
    private boolean countdown = false;
    private boolean updateGui = true;
    private String prefix = "";
    private boolean showFullFormat = false;
    private boolean keepDigitsLength = true;
    private boolean showMillis = false;
    private int countDownSec = 0;
    private TimeCategory showUpto = TimeCategory.DAY;
    String finalString = "";
    long time;
    private long pauseA = 0L;

    public TTimer() {
        this.text = Component.empty();
        this.setAutoScroll(false);
    }

    public static TTimer newTimerAndStart() {
        TTimer t = new TTimer();
        t.start();
        return t;
    }

    public static TTimer newTimerCountDown(int secs) {
        TTimer t = new TTimer();
        t.countDownSec = secs;
        t.countdown = true;
        return t;
    }

    public static TTimer newTimerCountDownAndStart(int secs) {
        TTimer t = TTimer.newTimerCountDown(secs);
        t.start();
        return t;
    }

    @Override
    public void tickT() {
        super.tickT();
        this.updateText();
    }

    private void updateText() {
        if (!this.updateGui) {
            return;
        }
        int ms = (int)(this.time % 1000L);
        int s = (int)(this.time / 1000L % 60L);
        int min = (int)(this.time / 1000L / 60L % 60L);
        int hour = (int)(this.time / 1000L / 60L / 60L % 60L);
        int day = (int)(this.time / 1000L / 60L / 60L / 24L);
        switch (this.showUpto.ordinal()) {
            case 0: {
                this.finalString = this.prefix + this.getRequiredFormat(s) + this.getRequiredFormatMs(ms);
                break;
            }
            case 1: {
                this.finalString = this.prefix + this.getRequiredFormat1(min) + this.getRequiredFormat(s) + this.getRequiredFormatMs(ms);
                break;
            }
            case 2: {
                this.finalString = this.prefix + this.getRequiredFormat1(hour) + this.getRequiredFormat1(min) + this.getRequiredFormat(s) + this.getRequiredFormatMs(ms);
                break;
            }
            default: {
                this.finalString = this.prefix + this.getRequiredFormat1(day) + this.getRequiredFormat1(hour) + this.getRequiredFormat1(min) + this.getRequiredFormat(s) + this.getRequiredFormatMs(ms);
            }
        }
        this.parseTextLines();
        ((MutableComponentAccessor)this.text).setContents((ComponentContents)new PlainTextContents.LiteralContents(this.finalString));
    }

    private String getRequiredFormat1(int i) {
        String s = this.getRequiredFormat(i);
        if (!s.isEmpty()) {
            return s + ":";
        }
        return s;
    }

    private String getRequiredFormat(int i) {
        if (i == 0) {
            if (this.showFullFormat) {
                if (this.keepDigitsLength) {
                    return "00";
                }
                return "0";
            }
            return "";
        }
        return this.keepDigitsLength ? String.format("%02d", i) : String.valueOf(i);
    }

    private String getRequiredFormatMs(int i) {
        if (!this.showMillis) {
            return "";
        }
        if (i == 0) {
            if (this.keepDigitsLength) {
                return ".000";
            }
            return ".0";
        }
        return this.keepDigitsLength ? String.format(".%03d", i) : "." + i;
    }

    @Override
    public void render(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.countdown) {
            if (this.startMs == 0L && this.pausedMs == 0L) {
                this.time = (long)this.countDownSec * 1000L;
            } else {
                this.time = this.startMs + this.pausedMs - System.currentTimeMillis();
                if (this.time <= 0L) {
                    this.time = 0L;
                    this.updateText();
                    this.updateGui = false;
                    NeoForge.EVENT_BUS.post((Event)new TimerCountdownReachEvent(this));
                }
            }
        } else {
            this.time = System.currentTimeMillis() - this.startMs - this.pausedMs;
        }
        int ms = (int)(this.time % 1000L);
        try {
            ((MutableComponentAccessor)this.text).setContents((ComponentContents)new PlainTextContents.LiteralContents(this.finalString.substring(0, this.finalString.indexOf(".")) + this.getRequiredFormatMs(ms)));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        super.render(guigraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void start() {
        this.updateGui = true;
        this.startMs = this.countdown ? System.currentTimeMillis() + (long)this.countDownSec * 1000L : System.currentTimeMillis();
    }

    public void pause() {
        this.pauseA = System.currentTimeMillis();
        this.updateGui = false;
    }

    public void resume() {
        this.pausedMs = System.currentTimeMillis() - this.pauseA;
        this.updateGui = true;
    }

    public void stop() {
        this.updateGui = false;
    }

    public long getStartMs() {
        return this.startMs;
    }

    public void setStartMs(long startMs) {
        this.startMs = startMs;
    }

    public long getPausedMs() {
        return this.pausedMs;
    }

    public void setPausedMs(long pausedMs) {
        this.pausedMs = pausedMs;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isShowFullFormat() {
        return this.showFullFormat;
    }

    public void setShowFullFormat(boolean showFullFormat) {
        this.showFullFormat = showFullFormat;
    }

    public boolean isKeepDigitsLength() {
        return this.keepDigitsLength;
    }

    public void setKeepDigitsLength(boolean keepDigitsLength) {
        this.keepDigitsLength = keepDigitsLength;
    }

    public boolean isShowMillis() {
        return this.showMillis;
    }

    public void setShowMillis(boolean showMillis) {
        this.showMillis = showMillis;
    }

    public boolean isUpdateGui() {
        return this.updateGui;
    }

    public void setUpdateGui(boolean updateGui) {
        this.updateGui = updateGui;
    }

    public TimeCategory getShowUpto() {
        return this.showUpto;
    }

    public void setShowUpto(TimeCategory showUpto) {
        this.showUpto = showUpto;
    }

    public boolean isCountdown() {
        return this.countdown;
    }

    public void setCountdown(boolean countdown) {
        this.countdown = countdown;
    }

    public int getCountDownSec() {
        return this.countDownSec;
    }

    public void setCountDownSec(int countDownSec) {
        this.countDownSec = countDownSec;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public static enum TimeCategory {
        SEC,
        MIN,
        HOUR,
        DAY;

    }
}

