/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.util;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockUtil {
    public static <T extends Comparable<T>> T justGetProperty(@Nullable BlockState first, BlockState backup, Property<T> property) {
        if (first != null) {
            return (T)first.getOptionalValue(property).orElse(backup.getValue(property));
        }
        return (T)backup.getValue(property);
    }

    public static Direction justGetFacing(@Nullable BlockState first, BlockState backup) {
        return (Direction)BlockUtil.justGetProperty(first, backup, BlockStateProperties.FACING);
    }

    public static ShapeHelper cube16(float x0, float x1, float y0, float y1, float z0, float z1) {
        return new ShapeHelper(new Vector3f(x0, y0, z0), new Vector3f(x1, y1, z1));
    }

    public static class ShapeHelper {
        Vector3f v1;
        Vector3f v2;

        public ShapeHelper(Vector3f corner1, Vector3f corner2) {
            this.v1 = corner1;
            this.v2 = corner2;
        }

        public ShapeHelper doo(Consumer<Vector3f> doer) {
            doer.accept(this.v1);
            doer.accept(this.v2);
            return this;
        }

        public VoxelShape getShape() {
            Vector3f min = new Vector3f((Vector3fc)this.v1).min((Vector3fc)this.v2);
            Vector3f max = new Vector3f((Vector3fc)this.v1).max((Vector3fc)this.v2);
            return Block.box((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
    }
}

