/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block;

import com.mafuyu33.mafishcrossbow.block.entity.CrossbowDispenserBlockEntity;
import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CrossbowDispenserBlock
extends DispenserBlock {
    public CrossbowDispenserBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrossbowDispenserBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof CrossbowDispenserBlockEntity) {
            player.openMenu((MenuProvider)blockentity);
        }
        return InteractionResult.CONSUME;
    }

    protected void dispenseFrom(ServerLevel level, BlockState state, BlockPos pos) {
        CrossbowDispenserBlockEntity blockEntity = level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.CROSSBOW_DISPENSER.get()).orElse(null);
        if (blockEntity != null) {
            blockEntity.dispense(level, state, pos);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CrossbowDispenserBlockEntity) {
            CrossbowDispenserBlockEntity blockEntity2 = (CrossbowDispenserBlockEntity)blockEntity;
            ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (enchantments != null && !enchantments.isEmpty()) {
                blockEntity2.setEnchantments(enchantments);
            }
            if (placer != null) {
                blockEntity2.setPlacerUUID(placer.getUUID());
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        CrossbowDispenserBlockEntity dispenserEntity;
        ItemEnchantments enchantments;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CrossbowDispenserBlockEntity && (enchantments = (dispenserEntity = (CrossbowDispenserBlockEntity)blockEntity).getEnchantments()) != null && !enchantments.isEmpty() && !player.isCreative()) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        CrossbowDispenserBlockEntity dispenserEntity;
        ItemEnchantments enchantments;
        BlockEntity blockEntity = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof CrossbowDispenserBlockEntity && (enchantments = (dispenserEntity = (CrossbowDispenserBlockEntity)blockEntity).getEnchantments()) != null && !enchantments.isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
            return List.of(stack);
        }
        return super.getDrops(state, params);
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        CrossbowDispenserBlockEntity dispenserEntity;
        ItemEnchantments enchantments;
        Level actualLevel;
        BlockEntity blockEntity;
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        if (includeData && level instanceof Level && (blockEntity = (actualLevel = (Level)level).getBlockEntity(pos)) instanceof CrossbowDispenserBlockEntity && (enchantments = (dispenserEntity = (CrossbowDispenserBlockEntity)blockEntity).getEnchantments()) != null && !enchantments.isEmpty()) {
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
        }
        return stack;
    }
}

