/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;

public class CustomFrostedIceBlock
extends IceBlock {
    public static final MapCodec<CustomFrostedIceBlock> CODEC = CustomFrostedIceBlock.simpleCodec(CustomFrostedIceBlock::new);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final int NEIGHBORS_TO_AGE = 4;
    private static final int NEIGHBORS_TO_MELT = 2;

    public MapCodec<CustomFrostedIceBlock> codec() {
        return CODEC;
    }

    public CustomFrostedIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)60, (int)120));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((random.nextInt(3) == 0 || this.fewerNeighboursThan((BlockGetter)level, pos, 4)) && level.getMaxLocalRawBrightness(pos) > 11 - (Integer)state.getValue((Property)AGE) - state.getLightBlock() && this.slightlyMelt(state, (Level)level, pos)) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutablePos.setWithOffset((Vec3i)pos, direction);
                BlockState neighborState = level.getBlockState((BlockPos)mutablePos);
                if (!neighborState.is((Block)this) || this.slightlyMelt(neighborState, (Level)level, (BlockPos)mutablePos)) continue;
                level.scheduleTick((BlockPos)mutablePos, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
            }
        } else {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
        }
    }

    private boolean slightlyMelt(BlockState state, Level level, BlockPos pos) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            return false;
        }
        this.melt(state, level, pos);
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        if (block.defaultBlockState().is((Block)this) && this.fewerNeighboursThan((BlockGetter)level, pos, 2)) {
            this.melt(state, level, pos);
        }
        super.neighborChanged(state, level, pos, block, orientation, isMoving);
    }

    private boolean fewerNeighboursThan(BlockGetter level, BlockPos pos, int neighborsRequired) {
        int count = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)mutablePos).is((Block)this) || ++count < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected void melt(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return ItemStack.EMPTY;
    }
}

