/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block.entity;

import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class CrossbowDispenserBlockEntity
extends DispenserBlockEntity {
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private UUID placerUUID;
    private int shulkerBoxIndex = 0;

    public CrossbowDispenserBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CROSSBOW_DISPENSER.get(), pos, blockState);
    }

    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
        this.setChanged();
    }

    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    public void setPlacerUUID(UUID uuid) {
        this.placerUUID = uuid;
        this.setChanged();
    }

    public UUID getPlacerUUID() {
        return this.placerUUID;
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        if (!this.enchantments.isEmpty()) {
            out.store("mafishcrossbow_enchantments", ItemEnchantments.CODEC, (Object)this.enchantments);
        }
        if (this.placerUUID != null) {
            out.store("mafishcrossbow_placer", UUIDUtil.CODEC, (Object)this.placerUUID);
        }
        out.store("mafishcrossbow_shulker_index", ExtraCodecs.NON_NEGATIVE_INT, (Object)this.shulkerBoxIndex);
    }

    protected void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.enchantments = in.read("mafishcrossbow_enchantments", ItemEnchantments.CODEC).orElse(ItemEnchantments.EMPTY);
        this.placerUUID = in.read("mafishcrossbow_placer", UUIDUtil.CODEC).orElse(null);
        this.shulkerBoxIndex = in.read("mafishcrossbow_shulker_index", ExtraCodecs.NON_NEGATIVE_INT).orElse(0);
    }

    public void dispense(ServerLevel level, BlockState state, BlockPos pos) {
        Object accumulatedEnchantments;
        BlockItem blockItem;
        int i;
        boolean hasInfinity = this.enchantments != null && this.enchantments.getLevel(level.holderOrThrow(Enchantments.INFINITY)) > 0;
        Direction direction = (Direction)state.getValue((Property)DispenserBlock.FACING);
        CrossbowDispenserBlockEntity container = this;
        ItemStack shulkerBoxStack = null;
        int shulkerBoxSlot = -1;
        for (i = 0; i < container.getContainerSize(); ++i) {
            Item item2;
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item2).getBlock() instanceof ShulkerBoxBlock)) continue;
            shulkerBoxStack = stack;
            shulkerBoxSlot = i;
            break;
        }
        if (shulkerBoxStack != null) {
            ItemContainerContents shulkerContents = (ItemContainerContents)shulkerBoxStack.get(DataComponents.CONTAINER);
            if (shulkerContents == null) {
                return;
            }
            ArrayList items = new ArrayList();
            shulkerContents.stream().forEach(items::add);
            if (items.isEmpty()) {
                return;
            }
            boolean hasNonEnchantedBook = items.stream().anyMatch(item -> !item.isEmpty() && item.getItem() != Items.ENCHANTED_BOOK);
            if (hasNonEnchantedBook) {
                accumulatedEnchantments = new HashMap();
                if (this.enchantments != null && !this.enchantments.isEmpty()) {
                    this.enchantments.entrySet().forEach(arg_0 -> CrossbowDispenserBlockEntity.lambda$dispense$1((Map)accumulatedEnchantments, arg_0));
                }
                if (hasInfinity) {
                    int idx = this.shulkerBoxIndex;
                    int scannedItems = 0;
                    ItemStack foundProjectile = null;
                    ItemEnchantments foundEnchantments = null;
                    while (foundProjectile == null && scannedItems < items.size()) {
                        ItemStack item3 = (ItemStack)items.get(idx % items.size());
                        ++scannedItems;
                        if (item3.isEmpty()) {
                            ++idx;
                            continue;
                        }
                        if (item3.getItem() == Items.ENCHANTED_BOOK) {
                            ItemEnchantments bookEnchantments = (ItemEnchantments)item3.get(DataComponents.STORED_ENCHANTMENTS);
                            if (bookEnchantments != null) {
                                bookEnchantments.entrySet().forEach(arg_0 -> CrossbowDispenserBlockEntity.lambda$dispense$2((Map)accumulatedEnchantments, arg_0));
                            }
                            ++idx;
                            continue;
                        }
                        foundProjectile = item3.copy();
                        foundProjectile.setCount(1);
                        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                        accumulatedEnchantments.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)mutable).set(arg_0, arg_1));
                        foundEnchantments = mutable.toImmutable();
                        ++idx;
                    }
                    if (foundProjectile != null && this.fireProjectileWithEnchantments(level, state, pos, direction, foundProjectile, foundEnchantments, true)) {
                        this.shulkerBoxIndex = idx;
                        this.setChanged();
                    }
                    return;
                }
                ArrayList<ItemStack> mutableItems = new ArrayList<ItemStack>();
                for (ItemStack item4 : items) {
                    mutableItems.add(item4.copy());
                }
                int idx = this.shulkerBoxIndex;
                int scannedItems = 0;
                ItemStack foundProjectile = null;
                ItemEnchantments foundEnchantments = null;
                while (foundProjectile == null && scannedItems < items.size()) {
                    ItemStack item5 = (ItemStack)mutableItems.get(idx % mutableItems.size());
                    ++scannedItems;
                    if (item5.isEmpty()) {
                        ++idx;
                        continue;
                    }
                    if (item5.getItem() == Items.ENCHANTED_BOOK) {
                        ItemEnchantments bookEnchantments = (ItemEnchantments)item5.get(DataComponents.STORED_ENCHANTMENTS);
                        if (bookEnchantments != null) {
                            bookEnchantments.entrySet().forEach(arg_0 -> CrossbowDispenserBlockEntity.lambda$dispense$3((Map)accumulatedEnchantments, arg_0));
                        }
                        ++idx;
                        continue;
                    }
                    foundProjectile = item5.copy();
                    foundProjectile.setCount(1);
                    ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                    accumulatedEnchantments.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)mutable).set(arg_0, arg_1));
                    foundEnchantments = mutable.toImmutable();
                    ++idx;
                    break;
                }
                if (foundProjectile != null) {
                    int foundIndex = (idx - 1) % mutableItems.size();
                    if (foundIndex < 0) {
                        foundIndex += mutableItems.size();
                    }
                    ItemStack itemToConsume = (ItemStack)mutableItems.get(foundIndex);
                    if (this.fireProjectileWithEnchantments(level, state, pos, direction, foundProjectile, foundEnchantments, false)) {
                        itemToConsume.shrink(1);
                        ArrayList<ItemStack> finalItems = new ArrayList<ItemStack>();
                        for (ItemStack item6 : mutableItems) {
                            finalItems.add(item6);
                        }
                        shulkerBoxStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(finalItems));
                        this.setItem(shulkerBoxSlot, shulkerBoxStack);
                        this.shulkerBoxIndex = idx;
                        this.setChanged();
                    }
                }
                return;
            }
        }
        for (i = 0; i < container.getContainerSize(); ++i) {
            DefaultDispenseItemBehavior dispenseBehavior;
            ItemStack itemstack = container.getItem(i);
            if (itemstack.isEmpty() || (accumulatedEnchantments = itemstack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)accumulatedEnchantments).getBlock() instanceof ShulkerBoxBlock) continue;
            if (this.fireProjectile(level, state, pos, direction, itemstack, hasInfinity)) {
                if (!hasInfinity) {
                    itemstack.shrink(1);
                    this.setChanged();
                }
                return;
            }
            BlockSource blocksource = new BlockSource(level, pos, state, (DispenserBlockEntity)this);
            if (!itemstack.isItemEnabled(level.enabledFeatures())) {
                dispenseBehavior = new DefaultDispenseItemBehavior();
            } else {
                dispenseBehavior = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(itemstack.getItem());
                if (dispenseBehavior == null) {
                    Object object = dispenseBehavior = itemstack.has(DataComponents.EQUIPPABLE) ? EquipmentDispenseItemBehavior.INSTANCE : new DefaultDispenseItemBehavior();
                }
            }
            if (dispenseBehavior != DispenseItemBehavior.NOOP) {
                ItemStack result = dispenseBehavior.dispense(blocksource, itemstack);
                if (!hasInfinity) {
                    this.setItem(i, result);
                }
            }
            return;
        }
    }

    private boolean fireProjectile(ServerLevel level, BlockState state, BlockPos pos, Direction direction, ItemStack itemstack, boolean keepItem) {
        StaticShooterContext shooterContext;
        Projectile projectile;
        Entity entity;
        BlockSource blocksource = new BlockSource(level, pos, state, (DispenserBlockEntity)this);
        Position dispensePos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
        Vec3 spawnPos = new Vec3(dispensePos.x(), dispensePos.y(), dispensePos.z());
        Vec3 shootVec = new Vec3((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ()).normalize();
        LivingEntity owner = null;
        if (this.placerUUID != null && (entity = level.getEntity(this.placerUUID)) instanceof LivingEntity) {
            LivingEntity living;
            owner = living = (LivingEntity)entity;
        }
        ItemStack dispenserAsWeapon = new ItemStack((ItemLike)Items.CROSSBOW);
        if (this.enchantments != null && !this.enchantments.isEmpty()) {
            dispenserAsWeapon.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        }
        if ((projectile = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile((Level)level, shooterContext = new StaticShooterContext(spawnPos, shootVec, owner), dispenserAsWeapon, itemstack)) != null) {
            if (keepItem) {
                InfinityHelper.markAsInfinitySource(projectile);
            }
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            float yRot = (float)Math.toDegrees(Math.atan2(shootVec.x, shootVec.z));
            float xRot = (float)(-Math.toDegrees(Math.atan2(shootVec.y, shootVec.horizontalDistance())));
            projectile.setYRot(yRot);
            projectile.setXRot(xRot);
            projectile.yRotO = yRot;
            projectile.xRotO = xRot;
            projectile.setDeltaMovement(shootVec.scale(3.0));
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.shootFromRotation((Entity)(owner != null ? owner : projectile), xRot, yRot, 0.0f, 3.0f, 0.0f);
            } else if (projectile instanceof ThrowableProjectile) {
                ThrowableProjectile throwable = (ThrowableProjectile)projectile;
                throwable.shootFromRotation((Entity)(owner != null ? owner : throwable), xRot, yRot, 0.0f, 3.0f, 0.0f);
            }
            level.addFreshEntity((Entity)projectile);
            level.levelEvent(1000, pos, 0);
            level.levelEvent(2000, pos, direction.get3DDataValue());
            return true;
        }
        return false;
    }

    private boolean fireProjectileWithEnchantments(ServerLevel level, BlockState state, BlockPos pos, Direction direction, ItemStack itemstack, ItemEnchantments projectileEnchantments, boolean keepItem) {
        StaticShooterContext shooterContext;
        Projectile projectile;
        Entity entity;
        BlockSource blocksource = new BlockSource(level, pos, state, (DispenserBlockEntity)this);
        Position dispensePos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
        Vec3 spawnPos = new Vec3(dispensePos.x(), dispensePos.y(), dispensePos.z());
        Vec3 shootVec = new Vec3((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ()).normalize();
        LivingEntity owner = null;
        if (this.placerUUID != null && (entity = level.getEntity(this.placerUUID)) instanceof LivingEntity) {
            LivingEntity living;
            owner = living = (LivingEntity)entity;
        }
        ItemStack dispenserAsWeapon = new ItemStack((ItemLike)Items.CROSSBOW);
        if (projectileEnchantments != null && !projectileEnchantments.isEmpty()) {
            dispenserAsWeapon.set(DataComponents.ENCHANTMENTS, (Object)projectileEnchantments);
        }
        if ((projectile = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile((Level)level, shooterContext = new StaticShooterContext(spawnPos, shootVec, owner), dispenserAsWeapon, itemstack)) != null) {
            if (keepItem) {
                InfinityHelper.markAsInfinitySource(projectile);
            }
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            float yRot = (float)Math.toDegrees(Math.atan2(shootVec.x, shootVec.z));
            float xRot = (float)(-Math.toDegrees(Math.atan2(shootVec.y, shootVec.horizontalDistance())));
            projectile.setYRot(yRot);
            projectile.setXRot(xRot);
            projectile.yRotO = yRot;
            projectile.xRotO = xRot;
            projectile.setDeltaMovement(shootVec.scale(3.0));
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.shootFromRotation((Entity)(owner != null ? owner : projectile), xRot, yRot, 0.0f, 3.0f, 0.0f);
            } else if (projectile instanceof ThrowableProjectile) {
                ThrowableProjectile throwable = (ThrowableProjectile)projectile;
                throwable.shootFromRotation((Entity)(owner != null ? owner : throwable), xRot, yRot, 0.0f, 3.0f, 0.0f);
            }
            level.addFreshEntity((Entity)projectile);
            level.levelEvent(1000, pos, 0);
            level.levelEvent(2000, pos, direction.get3DDataValue());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$dispense$3(Map accumulatedEnchantments, Object2IntMap.Entry entry) {
        accumulatedEnchantments.merge((Holder)entry.getKey(), entry.getValue(), Integer::sum);
    }

    private static /* synthetic */ void lambda$dispense$2(Map accumulatedEnchantments, Object2IntMap.Entry entry) {
        accumulatedEnchantments.merge((Holder)entry.getKey(), entry.getValue(), Integer::sum);
    }

    private static /* synthetic */ void lambda$dispense$1(Map accumulatedEnchantments, Object2IntMap.Entry entry) {
        accumulatedEnchantments.put((Holder)entry.getKey(), entry.getValue());
    }
}

