/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.enchantment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.extensions.IHolderExtension;

public class ModEnchantmentHelper {
    public static int getEnchantmentLevel(ResourceKey<Enchantment> enchantments, ItemStack stack) {
        ItemEnchantments itemenchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            ResourceKey enchantmentKey = ((Holder)entry.getKey()).getKey();
            if (enchantmentKey == null || !enchantmentKey.equals(enchantments)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    public static void enchant(ResourceKey<Enchantment> enchantmentKey, ItemStack stack, int level, HolderLookup.Provider lookup) {
        HolderLookup.RegistryLookup enchantmentLookup = lookup.lookupOrThrow(Registries.ENCHANTMENT);
        Optional optHolder = enchantmentLookup.get(enchantmentKey);
        optHolder.ifPresent(holder -> stack.enchant((Holder)holder, level));
    }

    public static ResourceLocation getEnchantmentResourceLocation(ResourceKey<Enchantment> enchantmentKey) {
        return enchantmentKey.location();
    }

    public static Optional<ResourceKey<Enchantment>> getEnchantmentKeyFromResourceLocation(ResourceLocation id, HolderLookup.Provider lookup) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
        HolderLookup.RegistryLookup enchantmentLookup = lookup.lookupOrThrow(Registries.ENCHANTMENT);
        Optional holder = enchantmentLookup.get(key);
        return holder.map(IHolderExtension::getKey);
    }
}

