/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.EntityVelocityUpdateS2CPacket;
import com.mafuyu33.mafishcrossbow.util.CrossbowDepthUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlackholeProjectile
extends TrailEntity {
    private static final int MAX_LIFETIME = 20;
    private int lifetime = 0;
    private static final EntityDataAccessor<Integer> DATA_RADIUS = SynchedEntityData.defineId(BlackholeProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String TAG_RADIUS = "Radius";

    public BlackholeProjectile(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public BlackholeProjectile(Level level, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.BLACKHOLE_PROJECTILE.get()), level);
        this.setOwner((Entity)owner);
        if (owner != null) {
            this.setPos(owner.getX(), owner.getEyeY(), owner.getZ());
        }
        this.setNoGravity(true);
        this.noPhysics = true;
        this.entityData.set(DATA_RADIUS, (Object)CrossbowDepthUtil.get(stack));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_RADIUS, (Object)0);
    }

    private int getRadius() {
        return 20 + (Integer)this.entityData.get(DATA_RADIUS);
    }

    protected Item getDefaultItem() {
        return Items.STRUCTURE_VOID;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        if (this.tickCount == 2 && !this.level().isClientSide()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITHER_AMBIENT, SoundSource.NEUTRAL, 1.2f, 0.35f);
        }
        if (!this.level().isClientSide()) {
            ++this.lifetime;
            int modifiedMaxLifetime = 20;
            modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
            if (this.lifetime > (modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData()))) {
                this.discard();
                return;
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            return;
        }
        ServerLevel srv = (ServerLevel)this.level();
        srv.sendParticles((ParticleOptions)ParticleTypes.PORTAL, true, true, this.getX(), this.getY(), this.getZ(), 20, 0.3, 0.3, 0.3, 0.02);
        srv.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, true, true, this.getX(), this.getY(), this.getZ(), 10, 0.2, 0.2, 0.2, 0.0);
        double attractionRadius = 0.3125 * (double)this.getRadius() + 1.5;
        AABB area = this.getBoundingBox().inflate(attractionRadius);
        List targets = srv.getEntities((Entity)this, area, e -> !(e instanceof BlackholeProjectile));
        for (Entity e2 : targets) {
            double tangentialSpd;
            double attractionSpd;
            Vec3 toCenter = this.position().subtract(e2.position());
            double dist = toCenter.length();
            Vec3 dir = toCenter.normalize();
            if (e2 instanceof BlackholeProjectile) {
                attractionSpd = 2.5 / dist;
                tangentialSpd = 0.1 / dist;
            } else {
                attractionSpd = 0.375 * (double)this.getRadius() / dist;
                tangentialSpd = 0.028124999999999997 * (double)this.getRadius() / dist;
            }
            Vec3 v = e2.getDeltaMovement().scale(0.7).add(dir.scale(attractionSpd)).add(new Vec3(toCenter.z, 0.0, -toCenter.x).normalize().scale(tangentialSpd)).add(0.0, e2.getGravity() / 3.0, 0.0);
            if (v.length() > 30.0) {
                v = v.normalize().scale(30.0);
            }
            e2.setDeltaMovement(v);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new EntityVelocityUpdateS2CPacket(e2.getId(), v), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        int r = 3 * (this.getRadius() - 18) - 6;
        int r2 = r * r;
        BlockPos center = this.blockPosition();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int dx = -r; dx <= r; ++dx) {
            int dx2 = dx * dx;
            for (int dy = -r; dy <= r; ++dy) {
                int dy2 = dy * dy;
                for (int dz = -r; dz <= r; ++dz) {
                    if (dx2 + dy2 + dz * dz > r2) continue;
                    mPos.set(center.getX() + dx, center.getY() + dy, center.getZ() + dz);
                    if (this.level().getBlockState((BlockPos)mPos).isAir()) continue;
                    this.level().setBlock((BlockPos)mPos, Blocks.AIR.defaultBlockState(), 18);
                }
            }
        }
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        out.putInt(TAG_RADIUS, ((Integer)this.entityData.get(DATA_RADIUS)).intValue());
    }

    protected void readAdditionalSaveData(ValueInput in) {
        super.readAdditionalSaveData(in);
        int radius = in.getIntOr(TAG_RADIUS, 0);
        this.entityData.set(DATA_RADIUS, (Object)radius);
    }
}

