/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BlazeFlameProjectile
extends TrailEntity {
    private static final float FLAME_DAMAGE = 3.0f;
    private static final double FLAME_RANGE = 0.5;
    private static final int DEFAULT_LIFETIME = 5;
    private static final int HIT_COOLDOWN = 20;
    private int flameTickCount = 0;
    private int maxLifetime = 5;
    private final Map<Integer, Integer> hitCooldowns = new HashMap<Integer, Integer>();

    public BlazeFlameProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public BlazeFlameProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item, Vec3 startPos) {
        super(entityType, owner, level, item);
        this.setNoGravity(true);
        this.setPos(startPos);
    }

    protected Item getDefaultItem() {
        return Items.BLAZE_POWDER;
    }

    public void setMaxLifetime(int lifetime) {
        this.maxLifetime = Math.max(1, lifetime);
    }

    public static int getDefaultLifetime() {
        return 5;
    }

    public static int getHitCooldown() {
        return 20;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.flameTickCount == 0 && !this.level().isClientSide) {
            int baseLifetime;
            int modifiedLifetime = baseLifetime = 5;
            modifiedLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedLifetime, this.getPersistentData());
            this.maxLifetime = modifiedLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedLifetime, this.getPersistentData());
        }
        ++this.flameTickCount;
        if (!this.level().isClientSide) {
            this.hitCooldowns.entrySet().removeIf(entry -> {
                entry.setValue((Integer)entry.getValue() - 1);
                return (Integer)entry.getValue() <= 0;
            });
            this.spawnFlameParticles();
            this.damageEntitiesInPath();
            if (this.flameTickCount > this.maxLifetime) {
                this.discard();
            }
        }
        if (this.flameTickCount % 10 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.HOSTILE, 0.5f, 1.2f);
        }
    }

    private void spawnFlameParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 currentPos = this.position();
            Vec3 prevPos = new Vec3(this.xOld, this.yOld, this.zOld);
            Vec3 motion = this.getDeltaMovement().normalize();
            double distance = currentPos.distanceTo(prevPos);
            int samplePoints = Math.max(1, (int)(distance / 0.25));
            for (int i = 0; i < samplePoints; ++i) {
                double velocityY;
                double velocityZ;
                double velocityX;
                double offsetY;
                double offsetZ;
                double offsetX;
                double radius;
                double angle;
                double t = (double)i / (double)samplePoints;
                Vec3 centerPos = prevPos.lerp(currentPos, t);
                double age = (double)this.flameTickCount + t;
                double expansion = Math.min(0.8, age * 0.02);
                double turbulenceTime = age * 0.1;
                double turbulenceX = Math.sin(turbulenceTime * 2.3) * 0.02;
                double turbulenceZ = Math.cos(turbulenceTime * 1.7) * 0.02;
                int coreParticles = 6;
                for (int j = 0; j < coreParticles; ++j) {
                    double angle2 = (double)j / (double)coreParticles * Math.PI * 2.0;
                    double radius2 = this.random.nextDouble() * 0.08 * expansion;
                    double offsetX2 = Math.cos(angle2) * radius2;
                    double offsetZ2 = Math.sin(angle2) * radius2;
                    double offsetY2 = (this.random.nextDouble() - 0.5) * 0.05 * expansion;
                    double velocityX2 = offsetX2 * 0.02 + turbulenceX;
                    double velocityZ2 = offsetZ2 * 0.02 + turbulenceZ;
                    double velocityY2 = 0.08 + this.random.nextDouble() * 0.04;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, true, false, centerPos.x + offsetX2, centerPos.y + offsetY2, centerPos.z + offsetZ2, 1, velocityX2, velocityY2, velocityZ2, 0.01);
                }
                int midParticles = 6;
                for (int j = 0; j < midParticles; ++j) {
                    double angle3 = this.random.nextDouble() * Math.PI * 2.0;
                    double radius3 = 0.1 + this.random.nextDouble() * 0.3 * expansion;
                    double offsetX3 = Math.cos(angle3) * radius3;
                    double offsetZ3 = Math.sin(angle3) * radius3;
                    double offsetY3 = (this.random.nextDouble() - 0.3) * 0.2 * expansion;
                    double turbulence = Math.sin(age * 0.5 + (double)j * 0.3) * 0.03;
                    double velocityX3 = (offsetX3 += turbulence) * 0.03 + turbulenceX * 2.0 + (this.random.nextDouble() - 0.5) * 0.02;
                    double velocityZ3 = (offsetZ3 += Math.cos(age * 0.4 + (double)j * 0.3) * 0.03) * 0.03 + turbulenceZ * 2.0 + (this.random.nextDouble() - 0.5) * 0.02;
                    double velocityY3 = 0.1 + this.random.nextDouble() * 0.08;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, true, false, centerPos.x + offsetX3, centerPos.y + offsetY3, centerPos.z + offsetZ3, 1, velocityX3, velocityY3, velocityZ3, 0.02);
                }
                if (i % 2 == 0) {
                    int smokeParticles = 6;
                    for (int j = 0; j < smokeParticles; ++j) {
                        angle = this.random.nextDouble() * Math.PI * 2.0;
                        radius = 0.3 + this.random.nextDouble() * 0.5 * expansion;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        offsetY = (this.random.nextDouble() - 0.7) * 0.3 * expansion;
                        velocityX = offsetX * 0.05 + turbulenceX * 3.0 + (this.random.nextDouble() - 0.5) * 0.03;
                        velocityZ = offsetZ * 0.05 + turbulenceZ * 3.0 + (this.random.nextDouble() - 0.5) * 0.03;
                        velocityY = 0.15 + this.random.nextDouble() * 0.1;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, true, false, centerPos.x + offsetX, centerPos.y + offsetY, centerPos.z + offsetZ, 1, velocityX, velocityY, velocityZ, 0.05);
                    }
                }
                if (this.random.nextDouble() < 0.3) {
                    int emberCount = 2;
                    for (int j = 0; j < emberCount; ++j) {
                        angle = this.random.nextDouble() * Math.PI * 2.0;
                        radius = this.random.nextDouble() * 0.4 * expansion;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        offsetY = this.random.nextDouble() * 0.1;
                        velocityX = (this.random.nextDouble() - 0.5) * 0.1 + turbulenceX;
                        velocityZ = (this.random.nextDouble() - 0.5) * 0.1 + turbulenceZ;
                        velocityY = 0.2 + this.random.nextDouble() * 0.15;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, true, false, centerPos.x + offsetX, centerPos.y + offsetY, centerPos.z + offsetZ, 1, velocityX, velocityY, velocityZ, 0.0);
                    }
                }
                if (i % 3 != 0) continue;
                double heatOffsetX = (this.random.nextDouble() - 0.5) * expansion + turbulenceX * 2.0;
                double heatOffsetZ = (this.random.nextDouble() - 0.5) * expansion + turbulenceZ * 2.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, false, centerPos.x + heatOffsetX, centerPos.y - 0.2, centerPos.z + heatOffsetZ, 1, heatOffsetX * 0.02, 0.08, heatOffsetZ * 0.02, 0.01);
            }
        }
    }

    private void damageEntitiesInPath() {
        Vec3 currentPos = this.position();
        Vec3 prevPos = new Vec3(this.xOld, this.yOld, this.zOld);
        double distance = currentPos.distanceTo(prevPos);
        int checkPoints = Math.max(1, (int)(distance / 0.5) + 1);
        for (int i = 0; i < checkPoints; ++i) {
            double t = (double)i / (double)(checkPoints - 1);
            Vec3 checkPos = prevPos.lerp(currentPos, t);
            AABB damageBounds = new AABB(checkPos.x - 0.5, checkPos.y - 0.5, checkPos.z - 0.5, checkPos.x + 0.5, checkPos.y + 0.5, checkPos.z + 0.5);
            List entities = this.level().getEntities((Entity)this, damageBounds);
            for (Entity entity : entities) {
                int entityId;
                if (!(entity instanceof LivingEntity) || entity == this.getOwner() || this.hitCooldowns.containsKey(entityId = entity.getId())) continue;
                this.hitCooldowns.put(entityId, 20);
                float baseDamage = 3.0f;
                float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
                finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
                entity.hurt(this.damageSources().onFire(), finalDamage);
                entity.setRemainingFireTicks(60);
            }
        }
    }

    private void setBlocksOnFire() {
        Vec3 currentPos = this.position();
        Vec3 prevPos = new Vec3(this.xOld, this.yOld, this.zOld);
        double distance = currentPos.distanceTo(prevPos);
        int checkPoints = Math.max(1, (int)distance + 1);
        for (int i = 0; i < checkPoints; ++i) {
            double t = (double)i / (double)Math.max(1, checkPoints - 1);
            Vec3 checkPosVec = prevPos.lerp(currentPos, t);
            BlockPos checkBlockPos = BlockPos.containing((Position)checkPosVec);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockState fireState;
                        BlockPos firePos = checkBlockPos.offset(x, y, z);
                        if (!this.level().isEmptyBlock(firePos)) continue;
                        boolean canPlaceFire = false;
                        for (Direction dir : Direction.values()) {
                            BlockPos adjacentPos = firePos.relative(dir);
                            BlockState adjacentState = this.level().getBlockState(adjacentPos);
                            if (!adjacentState.isSolidRender() || adjacentState.isAir()) continue;
                            canPlaceFire = true;
                            break;
                        }
                        if (!canPlaceFire || (fireState = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)firePos)) == null) continue;
                        this.level().setBlock(firePos, fireState, 11);
                    }
                }
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.createFireExplosion(result.getLocation());
            this.setLargeAreaOnFire(result.getBlockPos());
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        int entityId;
        if (!this.level().isClientSide && !this.hitCooldowns.containsKey(entityId = (entity = result.getEntity()).getId())) {
            this.hitCooldowns.put(entityId, 20);
            float baseDamage = 6.0f;
            float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            entity.hurt(this.damageSources().onFire(), finalDamage);
            entity.setRemainingFireTicks(100);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, true, false, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 10, 0.2, 0.2, 0.2, 0.05);
            }
        }
    }

    private void createFireExplosion(Vec3 location) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, true, false, location.x, location.y, location.z, 30, 0.5, 0.5, 0.5, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, true, false, location.x, location.y, location.z, 10, 0.3, 0.3, 0.3, 0.0);
            this.level().playSound(null, location.x, location.y, location.z, SoundEvents.FIRECHARGE_USE, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    private void setLargeAreaOnFire(BlockPos center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockState fireState;
                    BlockPos checkPos = center.offset(x, y, z);
                    if (!this.level().isEmptyBlock(checkPos)) continue;
                    boolean canPlaceFire = false;
                    BlockPos below = checkPos.below();
                    if (this.level().getBlockState(below).isSolidRender()) {
                        canPlaceFire = true;
                    }
                    BlockPos above = checkPos.above();
                    if (this.level().getBlockState(above).isSolidRender()) {
                        canPlaceFire = true;
                    }
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        BlockPos adjacentPos = checkPos.relative(dir);
                        if (!this.level().getBlockState(adjacentPos).isSolidRender()) continue;
                        canPlaceFire = true;
                        break;
                    }
                    if (!canPlaceFire || (fireState = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)checkPos)) == null) continue;
                    this.level().setBlock(checkPos, fireState, 11);
                }
            }
        }
    }
}

