/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.api.CustomFallable;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.accelerate.AccelerateHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.antigravity.AntigravityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.badluckofsea.BadLuckOfSeaHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.boreburst.BoreBurstHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decelerate.DecelerateHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaseinitialspeed.DecreaseInitialSpeedHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.frostwalker.FrostWalkerHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.gravity.GravityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaseinitialspeed.IncreaseInitialSpeedHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.intangible.IntangibleHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.nogravity.NoGravityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.noresistance.NoResistanceHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.redirect.RedirectHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.tracking.TrackingHelper;
import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class CustomFallingBlockEntity
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState DEFAULT_BLOCK_STATE = Blocks.SAND.defaultBlockState();
    private static final int DEFAULT_TIME = 0;
    private static final float DEFAULT_FALL_DAMAGE_PER_DISTANCE = 0.0f;
    private static final int DEFAULT_MAX_FALL_DAMAGE = 40;
    private static final boolean DEFAULT_DROP_ITEM = true;
    private static final boolean DEFAULT_CANCEL_DROP = false;
    private static final int MAX_LIFETIME = 1200;
    private static final int TEMPORARY_BLOCK_LIFETIME = 400;
    private int lifetime = 0;
    public BlockState blockState = DEFAULT_BLOCK_STATE;
    public int time = 0;
    public boolean dropItem = true;
    private boolean cancelDrop = false;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance = 0.0f;
    private int suffocateTickCooldown = 0;
    private LivingEntity mafishcrossbow$target;
    @Nullable
    public CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(CustomFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    protected static final EntityDataAccessor<BlockState> DATA_OTHER_HALF_STATE = SynchedEntityData.defineId(CustomFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    @Nullable
    public BlockState otherHalfState = null;

    public CustomFallingBlockEntity(EntityType<? extends CustomFallingBlockEntity> type, Level level) {
        super(type, level);
    }

    @Nullable
    public BlockState getOtherHalfState() {
        BlockState state = (BlockState)this.entityData.get(DATA_OTHER_HALF_STATE);
        return state.is(Blocks.AIR) ? null : state;
    }

    public void setOtherHalfState(@Nullable BlockState state) {
        this.entityData.set(DATA_OTHER_HALF_STATE, (Object)(state != null ? state : Blocks.AIR.defaultBlockState()));
    }

    private CustomFallingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends CustomFallingBlockEntity>)((EntityType)ModEntities.CUSTOM_FALLING_BLOCK.get()), level);
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public boolean isAttackable() {
        return false;
    }

    public final boolean hurtServer(ServerLevel p_376184_, DamageSource p_376594_, float p_376175_) {
        if (!this.isInvulnerableToBase(p_376594_)) {
            this.markHurt();
        }
        return false;
    }

    public void setStartPos(BlockPos startPos) {
        this.entityData.set(DATA_START_POS, (Object)startPos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.entityData.get(DATA_START_POS);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326465_) {
        p_326465_.define(DATA_START_POS, (Object)BlockPos.ZERO);
        p_326465_.define(DATA_OTHER_HALF_STATE, (Object)Blocks.AIR.defaultBlockState());
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            ++this.lifetime;
            int modifiedMaxLifetime = 1200;
            modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
            if (this.lifetime > (modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData()))) {
                ServerLevel serverlevel;
                Level level;
                if (this.dropItem && (level = this.level()) instanceof ServerLevel && (serverlevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && !InfinityHelper.hasInfinitySource(this)) {
                    this.spawnAtLocation(serverlevel, (ItemLike)this.blockState.getBlock());
                }
                this.discard();
                return;
            }
        }
        this.mafishcrossbow$target = TrackingHelper.update((Entity)this, this.getPersistentData(), this.mafishcrossbow$target);
        RedirectHelper.update((Entity)this, this.getPersistentData());
        GravityHelper.update((Entity)this, this.getPersistentData());
        AntigravityHelper.update((Entity)this, this.getPersistentData());
        BadLuckOfSeaHelper.update((Entity)this, this.getPersistentData());
        IncreaseInitialSpeedHelper.update((Entity)this, this.getPersistentData());
        DecreaseInitialSpeedHelper.update((Entity)this, this.getPersistentData());
        AccelerateHelper.update((Entity)this, this.getPersistentData());
        DecelerateHelper.update((Entity)this, this.getPersistentData());
        NoGravityHelper.update((Entity)this, this.getPersistentData());
        BoreBurstHelper.update((Entity)this, this.getPersistentData());
        FrostWalkerHelper.update((Entity)this, this.getPersistentData());
        IntangibleHelper.updateEntity((Entity)this, this.getPersistentData());
        if (this.blockState.isAir()) {
            this.discard();
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            this.handlePortal();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (this.isAlive() || this.forceTickAfterTeleportToDuplicate) {
                    BlockHitResult blockhitresult;
                    BlockPos blockpos = this.blockPosition();
                    boolean flag = this.blockState.getBlock() instanceof ConcretePowderBlock;
                    boolean flag1 = flag && this.blockState.canBeHydrated((BlockGetter)this.level(), blockpos, this.level().getFluidState(blockpos), blockpos);
                    double d0 = this.getDeltaMovement().lengthSqr();
                    if (flag && d0 > 1.0 && (blockhitresult = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.blockState.canBeHydrated((BlockGetter)this.level(), blockpos, this.level().getFluidState(blockhitresult.getBlockPos()), blockhitresult.getBlockPos())) {
                        blockpos = blockhitresult.getBlockPos();
                        flag1 = true;
                    }
                    if (!this.onGround() && !flag1) {
                        if (this.time > 100 && (blockpos.getY() <= this.level().getMinY() || blockpos.getY() > this.level().getMaxY()) || this.time > 600) {
                            if (this.dropItem && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && !InfinityHelper.hasInfinitySource(this)) {
                                this.spawnAtLocation(serverlevel, (ItemLike)block);
                            }
                            this.discard();
                        }
                    } else {
                        BlockState blockstate = this.level().getBlockState(blockpos);
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                        if (!blockstate.is(Blocks.MOVING_PISTON)) {
                            if (!this.cancelDrop) {
                                boolean flag4;
                                boolean flag2 = blockstate.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockpos, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                                boolean flag3 = FallingBlock.isFree((BlockState)this.level().getBlockState(blockpos.below())) && (!flag || !flag1);
                                boolean bl = flag4 = this.blockState.canSurvive((LevelReader)this.level(), blockpos) && !flag3;
                                if (flag2 && flag4) {
                                    if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockpos).getType() == Fluids.WATER) {
                                        this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                                    }
                                    if (this.level().setBlock(blockpos, this.blockState, 3)) {
                                        BlockEntity blockentity;
                                        BlockPos otherPos;
                                        BlockState otherHalf;
                                        ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.level().getBlockState(blockpos)));
                                        if (InfinityHelper.hasInfinitySource(this)) {
                                            int temporaryLifetime = this.getModifiedTemporaryBlockLifetime();
                                            TemporaryBlockTracker.markTemporary(this.level(), blockpos, temporaryLifetime);
                                        }
                                        if ((otherHalf = this.getOtherHalfState()) != null && (otherPos = this.getOtherHalfPos(blockpos, this.blockState, otherHalf)) != null && this.level().getBlockState(otherPos).canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), otherPos, Direction.DOWN, ItemStack.EMPTY, Direction.UP))) {
                                            this.level().setBlock(otherPos, otherHalf, 3);
                                            ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(otherPos, this.level().getBlockState(otherPos)));
                                            if (InfinityHelper.hasInfinitySource(this)) {
                                                int temporaryLifetime = this.getModifiedTemporaryBlockLifetime();
                                                TemporaryBlockTracker.markTemporary(this.level(), otherPos, temporaryLifetime);
                                            }
                                        }
                                        this.discard();
                                        if (block instanceof CustomFallable) {
                                            ((CustomFallable)block).onLand(this.level(), blockpos, this.blockState, blockstate, this);
                                        }
                                        if (this.blockData != null && this.blockState.hasBlockEntity() && (blockentity = this.level().getBlockEntity(blockpos)) != null) {
                                            try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(blockentity.problemPath(), LOGGER);){
                                                RegistryAccess registryaccess = this.level().registryAccess();
                                                TagValueOutput tagvalueoutput = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)registryaccess);
                                                blockentity.saveWithoutMetadata((ValueOutput)tagvalueoutput);
                                                CompoundTag compoundtag = tagvalueoutput.buildResult();
                                                this.blockData.forEach((p_409356_, p_409357_) -> compoundtag.put(p_409356_, p_409357_.copy()));
                                                blockentity.loadWithComponents(TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)registryaccess, (CompoundTag)compoundtag));
                                            }
                                            catch (Exception exception) {
                                                LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                            }
                                            blockentity.setChanged();
                                        }
                                    } else if (this.dropItem && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.discard();
                                        this.callOnBrokenAfterFall(block, blockpos);
                                        if (!InfinityHelper.hasInfinitySource(this)) {
                                            this.spawnAtLocation(serverlevel, (ItemLike)block);
                                        }
                                    }
                                } else {
                                    BlockPos fallbackPos = this.findNearbyValidPlacement(blockpos);
                                    if (fallbackPos != null) {
                                        this.blockState = this.tryWaterlog(this.blockState, fallbackPos);
                                        if (this.level().setBlock(fallbackPos, this.blockState, 3)) {
                                            BlockPos otherPos;
                                            BlockState otherHalf;
                                            ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(fallbackPos, this.level().getBlockState(fallbackPos)));
                                            if (InfinityHelper.hasInfinitySource(this)) {
                                                int temporaryLifetime = this.getModifiedTemporaryBlockLifetime();
                                                TemporaryBlockTracker.markTemporary(this.level(), fallbackPos, temporaryLifetime);
                                            }
                                            if ((otherHalf = this.getOtherHalfState()) != null && (otherPos = this.getOtherHalfPos(fallbackPos, this.blockState, otherHalf)) != null && this.level().getBlockState(otherPos).canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), otherPos, Direction.DOWN, ItemStack.EMPTY, Direction.UP))) {
                                                this.level().setBlock(otherPos, otherHalf, 3);
                                                ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(otherPos, this.level().getBlockState(otherPos)));
                                                if (InfinityHelper.hasInfinitySource(this)) {
                                                    int temporaryLifetime = this.getModifiedTemporaryBlockLifetime();
                                                    TemporaryBlockTracker.markTemporary(this.level(), otherPos, temporaryLifetime);
                                                }
                                            }
                                            this.discard();
                                            if (block instanceof CustomFallable) {
                                                CustomFallable customFallable = (CustomFallable)block;
                                                customFallable.onLand(this.level(), fallbackPos, this.blockState, this.level().getBlockState(fallbackPos), this);
                                            }
                                        }
                                    } else {
                                        this.discard();
                                        if (this.dropItem && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                            this.callOnBrokenAfterFall(block, blockpos);
                                            if (!InfinityHelper.hasInfinitySource(this)) {
                                                this.spawnAtLocation(serverlevel, (ItemLike)block);
                                            }
                                        }
                                    }
                                }
                            } else {
                                this.discard();
                                this.callOnBrokenAfterFall(block, blockpos);
                            }
                        }
                    }
                }
            }
            if (NoResistanceHelper.hasNoResistance((Entity)this)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(1.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
            }
            if (this.isAlive() && block instanceof CustomFallable) {
                CustomFallable feblock = (CustomFallable)block;
                feblock.fallingTick(this.level(), this.blockPosition(), this);
            }
            if (--this.suffocateTickCooldown <= 0 && this.isAlive() && !this.level().isClientSide) {
                this.suffocateTickCooldown = 20;
                this.applySuffocationDamage();
            }
        }
    }

    private void applySuffocationDamage() {
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), predicate)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).getBoundingBox().intersects(this.getBoundingBox())) continue;
            float baseDamage = 1.0f;
            float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            living.hurt(this.damageSources().inWall(), finalDamage);
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos pos) {
        if (block instanceof CustomFallable) {
            ((CustomFallable)block).onBrokenAfterFall(this.level(), pos, this);
        }
    }

    @Nullable
    private BlockPos findNearbyValidPlacement(BlockPos center) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    mutable.set(center.getX() + dx, center.getY() + dy, center.getZ() + dz);
                    BlockState targetState = this.level().getBlockState((BlockPos)mutable);
                    boolean canReplace = targetState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), (BlockPos)mutable, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                    boolean canSurvive = this.blockState.canSurvive((LevelReader)this.level(), (BlockPos)mutable);
                    if (!canReplace || !canSurvive) continue;
                    return mutable.immutable();
                }
            }
        }
        return null;
    }

    private BlockState tryWaterlog(BlockState state, BlockPos pos) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(pos).getType() == Fluids.WATER) {
            return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean causeFallDamage(double p_397518_, float p_149643_, DamageSource p_149645_) {
        DamageSource damageSource;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.ceil((double)(p_397518_ - 1.0));
        if (i < 0) {
            return false;
        }
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)block;
            damageSource = fallable.getFallDamageSource((Entity)this);
        } else {
            damageSource = this.damageSources().fallingBlock((Entity)this);
        }
        DamageSource damagesource = damageSource;
        float baseDamage = Math.min(Mth.floor((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
        float damageToApply = finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
        this.level().getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(p_375871_ -> p_375871_.hurt(damagesource, damageToApply));
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        if (flag && baseDamage > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.damage((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    protected void addAdditionalSaveData(ValueOutput p_421897_) {
        BlockState otherHalf;
        p_421897_.store("BlockState", BlockState.CODEC, (Object)this.blockState);
        p_421897_.putInt("Time", this.time);
        p_421897_.putBoolean("DropItem", this.dropItem);
        p_421897_.putBoolean("HurtEntities", this.hurtEntities);
        p_421897_.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        p_421897_.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            p_421897_.store("TileEntityData", CompoundTag.CODEC, (Object)this.blockData);
        }
        if ((otherHalf = this.getOtherHalfState()) != null) {
            p_421897_.store("OtherHalfState", BlockState.CODEC, (Object)otherHalf);
        }
        p_421897_.putBoolean("CancelDrop", this.cancelDrop);
    }

    protected void readAdditionalSaveData(ValueInput p_422622_) {
        this.blockState = p_422622_.read("BlockState", BlockState.CODEC).orElse(DEFAULT_BLOCK_STATE);
        this.time = p_422622_.getIntOr("Time", 0);
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        this.hurtEntities = p_422622_.getBooleanOr("HurtEntities", flag);
        this.fallDamagePerDistance = p_422622_.getFloatOr("FallHurtAmount", 0.0f);
        this.fallDamageMax = p_422622_.getIntOr("FallHurtMax", 40);
        this.dropItem = p_422622_.getBooleanOr("DropItem", true);
        this.blockData = p_422622_.read("TileEntityData", CompoundTag.CODEC).orElse(null);
        BlockState otherHalf = p_422622_.read("OtherHalfState", BlockState.CODEC).orElse(null);
        this.setOtherHalfState(otherHalf);
        this.cancelDrop = p_422622_.getBooleanOr("CancelDrop", false);
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        super.fillCrashReportCategory(category);
        category.setDetail("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    protected Component getTypeName() {
        return Component.translatable((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.getBlock().getName()});
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352287_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352287_, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_149654_) {
        super.recreateFromPacket(p_149654_);
        this.blockState = Block.stateById((int)p_149654_.getData());
        this.blocksBuilding = true;
        double d0 = p_149654_.getX();
        double d1 = p_149654_.getY();
        double d2 = p_149654_.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    private int getModifiedTemporaryBlockLifetime() {
        int baseLifetime = 400;
        baseLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, baseLifetime, this.getPersistentData());
        baseLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, baseLifetime, this.getPersistentData());
        return baseLifetime;
    }

    @Nullable
    private BlockPos getOtherHalfPos(BlockPos mainPos, BlockState mainState, BlockState otherState) {
        Half otherHalf;
        Half mainHalf;
        if (mainState.getBlock() != otherState.getBlock()) {
            return null;
        }
        if (mainState.getBlock() instanceof DoorBlock && mainState.hasProperty((Property)BlockStateProperties.HALF) && otherState.hasProperty((Property)BlockStateProperties.HALF)) {
            mainHalf = (Half)mainState.getValue((Property)BlockStateProperties.HALF);
            otherHalf = (Half)otherState.getValue((Property)BlockStateProperties.HALF);
            if (mainHalf == Half.BOTTOM && otherHalf == Half.TOP) {
                return mainPos.above();
            }
            if (mainHalf == Half.TOP && otherHalf == Half.BOTTOM) {
                return mainPos.below();
            }
        }
        if (mainState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && otherState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            mainHalf = (DoubleBlockHalf)mainState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
            otherHalf = (DoubleBlockHalf)otherState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
            if (mainHalf == DoubleBlockHalf.LOWER && otherHalf == DoubleBlockHalf.UPPER) {
                return mainPos.above();
            }
            if (mainHalf == DoubleBlockHalf.UPPER && otherHalf == DoubleBlockHalf.LOWER) {
                return mainPos.below();
            }
        }
        if (mainState.hasProperty((Property)BlockStateProperties.BED_PART) && otherState.hasProperty((Property)BlockStateProperties.BED_PART) && mainState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            BedPart mainPart = (BedPart)mainState.getValue((Property)BlockStateProperties.BED_PART);
            BedPart otherPart = (BedPart)otherState.getValue((Property)BlockStateProperties.BED_PART);
            Direction facing = (Direction)mainState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (mainPart == BedPart.FOOT && otherPart == BedPart.HEAD) {
                return mainPos.relative(facing);
            }
            if (mainPart == BedPart.HEAD && otherPart == BedPart.FOOT) {
                return mainPos.relative(facing.getOpposite());
            }
        }
        return null;
    }

    @Nullable
    public Entity teleport(TeleportTransition p_379492_) {
        ResourceKey resourcekey = p_379492_.newLevel().dimension();
        ResourceKey resourcekey1 = this.level().dimension();
        boolean flag = (resourcekey1 == Level.END || resourcekey == Level.END) && resourcekey1 != resourcekey;
        Entity entity = super.teleport(p_379492_);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }
}

