/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.LightningPathSyncPacket;
import com.mafuyu33.mafishcrossbow.util.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CustomLightningBoltEntity
extends TrailEntity {
    private static final double LIGHTNING_SPEED = 500.0;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final float LIGHTNING_DAMAGE = 20.0f;
    private static int MAX_LIFETIME = 10;
    private static final EntityDataAccessor<Float> START_X = SynchedEntityData.defineId(CustomLightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> START_Y = SynchedEntityData.defineId(CustomLightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> START_Z = SynchedEntityData.defineId(CustomLightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> STRUCK = SynchedEntityData.defineId(CustomLightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final List<Vec3> pathPoints = new ArrayList<Vec3>();
    private List<Vec3> clientPathPoints = new ArrayList<Vec3>();
    private int lifetime = 0;
    private Vec3 strikeEndPos = null;
    private int lastSyncTick = 0;

    public CustomLightningBoltEntity(EntityType<? extends ThrowableItemProjectile> p_37442_, Level p_37443_) {
        super(p_37442_, p_37443_);
        this.setTrailType("none");
        this.setNoGravity(true);
    }

    public CustomLightningBoltEntity(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level, ItemStack item) {
        super(entityType, x, y, z, level, item);
        this.setTrailType("none");
        this.setNoGravity(true);
        this.setStartPos(new Vec3(x, y, z));
        if (!level.isClientSide) {
            this.pathPoints.add(new Vec3(x, y, z));
        }
    }

    public CustomLightningBoltEntity(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item, Vec3 startPos) {
        super(entityType, owner, level, item);
        this.setTrailType("none");
        this.setNoGravity(true);
        this.setStartPos(startPos);
        this.setPos(startPos);
        if (!level.isClientSide) {
            this.pathPoints.add(startPos);
        }
    }

    public CustomLightningBoltEntity(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item) {
        super(entityType, owner, level, item);
        this.setTrailType("none");
        this.setNoGravity(true);
        if (owner != null) {
            Vec3 eyePos = owner.getEyePosition();
            this.setStartPos(eyePos);
            if (!level.isClientSide) {
                this.pathPoints.add(eyePos);
            }
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.MAFISH.get();
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(START_X, (Object)Float.valueOf(0.0f));
        builder.define(START_Y, (Object)Float.valueOf(0.0f));
        builder.define(START_Z, (Object)Float.valueOf(0.0f));
        builder.define(STRUCK, (Object)false);
    }

    public void setStartPos(Vec3 pos) {
        this.entityData.set(START_X, (Object)Float.valueOf((float)pos.x));
        this.entityData.set(START_Y, (Object)Float.valueOf((float)pos.y));
        this.entityData.set(START_Z, (Object)Float.valueOf((float)pos.z));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        Vec3 start = this.getStartPos();
        output.putDouble("StartX", start.x);
        output.putDouble("StartY", start.y);
        output.putDouble("StartZ", start.z);
        if (this.strikeEndPos != null) {
            output.putDouble("StrikeX", this.strikeEndPos.x);
            output.putDouble("StrikeY", this.strikeEndPos.y);
            output.putDouble("StrikeZ", this.strikeEndPos.z);
        }
        if (!this.pathPoints.isEmpty()) {
            output.putInt("PathPointsCount", this.pathPoints.size());
            for (int i = 0; i < this.pathPoints.size(); ++i) {
                Vec3 point = this.pathPoints.get(i);
                output.putDouble("PathPoint" + i + "X", point.x);
                output.putDouble("PathPoint" + i + "Y", point.y);
                output.putDouble("PathPoint" + i + "Z", point.z);
            }
        }
        output.putInt("Lifetime", this.lifetime);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        int pathPointsCount;
        super.readAdditionalSaveData(input);
        double x = input.getDoubleOr("StartX", 0.0);
        double y = input.getDoubleOr("StartY", 0.0);
        double z = input.getDoubleOr("StartZ", 0.0);
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setStartPos(new Vec3(x, y, z));
        }
        double sx = input.getDoubleOr("StrikeX", 0.0);
        double sy = input.getDoubleOr("StrikeY", 0.0);
        double sz = input.getDoubleOr("StrikeZ", 0.0);
        if (sx != 0.0 || sy != 0.0 || sz != 0.0) {
            this.strikeEndPos = new Vec3(sx, sy, sz);
        }
        if ((pathPointsCount = input.getIntOr("PathPointsCount", 0)) > 0) {
            this.pathPoints.clear();
            for (int i = 0; i < pathPointsCount; ++i) {
                double px = input.getDoubleOr("PathPoint" + i + "X", 0.0);
                double py = input.getDoubleOr("PathPoint" + i + "Y", 0.0);
                double pz = input.getDoubleOr("PathPoint" + i + "Z", 0.0);
                this.pathPoints.add(new Vec3(px, py, pz));
            }
        }
        this.lifetime = input.getIntOr("Lifetime", 0);
        if (!this.pathPoints.isEmpty() && !this.level().isClientSide) {
            this.setStartPos(this.pathPoints.get(0));
            this.syncPathToClients();
        }
    }

    @Override
    public void tick() {
        Vec3 currentStart;
        super.tick();
        ++this.lifetime;
        int modifiedMaxLifetime = MAX_LIFETIME;
        modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
        modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
        if (this.hasStruck()) {
            if (this.lifetime >= modifiedMaxLifetime + 20) {
                this.discard();
            }
            return;
        }
        if (!this.level().isClientSide) {
            this.pathPoints.add(this.position());
            if (this.tickCount - this.lastSyncTick >= 2 || this.hasStruck()) {
                this.syncPathToClients();
                this.lastSyncTick = this.tickCount;
            }
        } else {
            this.clientPathPoints.add(this.position());
        }
        if ((currentStart = this.getStartPos()).equals((Object)this.position()) && this.tickCount == 0 && !this.position().equals((Object)Vec3.ZERO)) {
            this.setStartPos(this.position());
        }
        if (this.lifetime >= modifiedMaxLifetime && !this.level().isClientSide) {
            this.strikeEndPos = this.position();
            this.performLightningStrike();
            this.setStruck(true);
            this.setDeltaMovement(Vec3.ZERO);
            this.syncPathToClients();
        }
    }

    public void shootFromRotation(Entity shooter, float xRot, float yRot, float p_37254_, float velocity, float inaccuracy) {
        super.shootFromRotation(shooter, xRot, yRot, p_37254_, (float)((double)velocity * 500.0), inaccuracy);
    }

    @Override
    protected void afterHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide && !this.hasStruck()) {
            this.pathPoints.add(result.getLocation());
            if (this.shouldBounce()) {
                this.syncPathToClients();
                return;
            }
            this.strikeEndPos = result.getLocation();
            this.performLightningStrike();
            this.setStruck(true);
            this.setDeltaMovement(Vec3.ZERO);
            this.setNoGravity(true);
            this.syncPathToClients();
        }
    }

    private boolean shouldBounce() {
        return this.getPersistentData().getIntOr("mafishcrossbow_bounceLeft", 0) > 0;
    }

    @Override
    protected void afterHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide && !this.hasStruck()) {
            Vec3 hitPos = result.getEntity().position();
            this.pathPoints.add(hitPos);
            this.strikeEndPos = hitPos;
            this.performLightningStrike();
            this.setStruck(true);
            this.setDeltaMovement(Vec3.ZERO);
            this.setNoGravity(true);
            this.syncPathToClients();
        }
    }

    private void performLightningStrike() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound(null, this.blockPosition(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10.0f, 0.8f + this.random.nextFloat() * 0.2f);
            serverLevel.playSound(null, this.blockPosition(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f);
            this.damageEntitiesAlongPath();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX(), this.getY(), this.getZ(), 50, 0.5, 0.5, 0.5, 0.2);
        }
    }

    private void damageEntitiesAlongPath() {
        if (this.pathPoints.isEmpty()) {
            return;
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (Vec3 point : this.pathPoints) {
            minX = Math.min(minX, point.x - 3.0);
            minY = Math.min(minY, point.y - 3.0);
            minZ = Math.min(minZ, point.z - 3.0);
            maxX = Math.max(maxX, point.x + 3.0);
            maxY = Math.max(maxY, point.y + 3.0);
            maxZ = Math.max(maxZ, point.z + 3.0);
        }
        AABB searchBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        for (LivingEntity entity : entities) {
            ServerLevel serverLevel;
            LightningBolt lightning;
            Level level;
            if (entity == this.getOwner()) continue;
            Vec3 entityPos = entity.position();
            boolean nearPath = false;
            for (Vec3 pathPoint : this.pathPoints) {
                if (!(entityPos.distanceTo(pathPoint) <= 3.0)) continue;
                nearPath = true;
                break;
            }
            if (!nearPath) continue;
            float baseDamage = 20.0f;
            float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            DamageSource damageSource = this.damageSources().lightningBolt();
            entity.hurt(damageSource, finalDamage);
            if (this.level().isClientSide || !((level = this.level()) instanceof ServerLevel) || (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)(serverLevel = (ServerLevel)level), EntitySpawnReason.TRIGGERED)) == null) continue;
            entity.thunderHit(serverLevel, lightning);
        }
    }

    public boolean hasStruck() {
        return (Boolean)this.entityData.get(STRUCK);
    }

    public void setStruck(boolean struck) {
        this.entityData.set(STRUCK, (Object)struck);
    }

    public Vec3 getStrikeEndPos() {
        return this.strikeEndPos != null ? this.strikeEndPos : this.position();
    }

    public List<Vec3> getPathPoints() {
        return new ArrayList<Vec3>(this.pathPoints);
    }

    public Vec3 getStartPos() {
        float x = ((Float)this.entityData.get(START_X)).floatValue();
        float y = ((Float)this.entityData.get(START_Y)).floatValue();
        float z = ((Float)this.entityData.get(START_Z)).floatValue();
        if (x == 0.0f && y == 0.0f && z == 0.0f && !this.position().equals((Object)Vec3.ZERO)) {
            return this.position();
        }
        return new Vec3((double)x, (double)y, (double)z);
    }

    private void syncPathToClients() {
        Level level;
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LightningPathSyncPacket packet = new LightningPathSyncPacket(this.getId(), new ArrayList<Vec3>(this.pathPoints));
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setClientPathPoints(List<Vec3> points) {
        this.clientPathPoints = new ArrayList<Vec3>(points);
        if (!points.isEmpty()) {
            this.setStartPos(points.get(0));
        }
    }

    public List<Vec3> getRenderPathPoints() {
        if (this.level().isClientSide) {
            Vec3 startPos;
            ArrayList<Vec3> renderPath;
            ArrayList<Vec3> arrayList = renderPath = this.clientPathPoints.isEmpty() ? new ArrayList<Vec3>(this.pathPoints) : new ArrayList<Vec3>(this.clientPathPoints);
            if (renderPath.isEmpty() && !(startPos = this.getStartPos()).equals((Object)Vec3.ZERO)) {
                renderPath.add(startPos);
                if (!this.position().equals((Object)Vec3.ZERO) && !this.position().equals((Object)startPos)) {
                    renderPath.add(this.position());
                }
            }
            return renderPath;
        }
        return new ArrayList<Vec3>(this.pathPoints);
    }
}

