/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.noresistance.NoResistanceHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CustomLlamaSpitEntity
extends Projectile {
    protected CustomLlamaSpitEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public CustomLlamaSpitEntity(Level world, LivingEntity owner) {
        this((EntityType<? extends Projectile>)EntityType.LLAMA_SPIT, world);
        if (owner != null) {
            this.setPos(owner.getX(), owner.getEyeY(), owner.getZ());
        }
    }

    public void tick() {
        super.tick();
        Vec3 vec3d = this.getDeltaMovement();
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        this.onHit(hitResult);
        double d = this.getX() + vec3d.x;
        double e = this.getY() + vec3d.y;
        double f = this.getZ() + vec3d.z;
        this.updateRotation();
        float g = 0.99f;
        float h = 0.06f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard();
        } else {
            if (NoResistanceHelper.hasNoResistance((Entity)this)) {
                this.setDeltaMovement(vec3d.scale(1.0));
            } else {
                this.setDeltaMovement(vec3d.scale((double)0.99f));
            }
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
            }
            this.setPos(d, e, f);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            float baseDamage = 1.0f;
            float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            result.getEntity().hurt(this.damageSources().mobProjectile((Entity)this, livingEntity), finalDamage);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        double d = packet.getX();
        double e = packet.getY();
        double f = packet.getZ();
        for (int i = 0; i < 7; ++i) {
            double g = 0.4 + 0.1 * (double)i;
            this.level().addParticle((ParticleOptions)ParticleTypes.SPIT, this.getX(), this.getY(), this.getZ(), d * g, e, f * g);
        }
        this.setPos(d, e, f);
    }
}

