/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityProjectileShell<T extends Entity>
extends Projectile {
    private final T embeddedEntity;
    private boolean deployed = false;

    public EntityProjectileShell(EntityType<? extends EntityProjectileShell<?>> type, Level level, T embeddedEntity) {
        super(type, level);
        this.embeddedEntity = embeddedEntity;
        this.noPhysics = true;
        this.setInvisible(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.embeddedEntity == null || !this.embeddedEntity.isAlive()) {
            this.discard();
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        if (!this.deployed) {
            Vec3 motion = this.getDeltaMovement();
            this.embeddedEntity.setDeltaMovement(motion);
            this.embeddedEntity.setPos(this.getX(), this.getY(), this.getZ());
            if (this.onGround() || this.tickCount > 0) {
                this.level().addFreshEntity(this.embeddedEntity);
                this.deployed = true;
                this.discard();
            }
        }
    }

    public T getEmbeddedEntity() {
        return this.embeddedEntity;
    }
}

