/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import com.mafuyu33.mafishcrossbow.util.CrossbowScatterUtil;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FiredCrossbowProjectile
extends TrailEntity {
    private static final int MAX_LIFETIME = 1200;
    private int lifetime;
    private boolean shouldDropOnHit;
    private boolean sourceHasInfinity;
    private static final String TAG_CROSSBOW = "CarriedCrossbow";
    private static final String TAG_DROP = "ShouldDropOnHit";
    private static final String TAG_SOURCE_INFINITY = "SourceHasInfinity";
    private static final EntityDataAccessor<ItemStack> CARRIED_CROSSBOW = SynchedEntityData.defineId(FiredCrossbowProjectile.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<String> TRAIL_TYPE = SynchedEntityData.defineId(FiredCrossbowProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public FiredCrossbowProjectile(EntityType<? extends FiredCrossbowProjectile> type, Level level) {
        super(type, level);
        this.lifetime = 0;
        this.shouldDropOnHit = true;
        this.sourceHasInfinity = false;
    }

    public FiredCrossbowProjectile(Level level, LivingEntity shooter, ItemStack ammoCrossbow, ItemStack sourceCrossbow) {
        block5: {
            block4: {
                super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.FIRED_CROSSBOW.get()), level);
                this.lifetime = 0;
                this.shouldDropOnHit = true;
                this.sourceHasInfinity = false;
                this.setOwner((Entity)shooter);
                if (shooter != null) {
                    this.setPos(shooter.getX(), shooter.getEyeY(), shooter.getZ());
                }
                this.setItem(ammoCrossbow);
                this.entityData.set(CARRIED_CROSSBOW, (Object)ammoCrossbow.copy());
                boolean bl = this.sourceHasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, sourceCrossbow) > 0;
                if (this.sourceHasInfinity) break block4;
                if (!(shooter instanceof Player)) break block5;
                Player player = (Player)shooter;
                if (!player.getAbilities().instabuild) break block5;
            }
            this.shouldDropOnHit = false;
        }
    }

    public void setSourceHasInfinity(boolean hasInfinity) {
        this.sourceHasInfinity = hasInfinity;
    }

    public boolean hasSourceInfinity() {
        return this.sourceHasInfinity;
    }

    protected Item getDefaultItem() {
        return Items.CROSSBOW;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (InfinityHelper.hasInfinitySource((Projectile)this)) {
                this.shouldDropOnHit = false;
            }
            ++this.lifetime;
            int modifiedMaxLifetime = 1200;
            modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
            if (this.lifetime > (modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData()))) {
                if (this.shouldDropOnHit) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem().copy()));
                }
                this.discard();
            }
        }
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CARRIED_CROSSBOW, (Object)ItemStack.EMPTY);
        builder.define(TRAIL_TYPE, (Object)"transition");
    }

    public void onRemoval(Entity.RemovalReason reason) {
        super.onRemoval(reason);
    }

    @Override
    protected void afterHitBlock(BlockHitResult blockHit) {
        int bounceLeft;
        if (this.isRemoved()) {
            return;
        }
        if (!this.level().isClientSide && (bounceLeft = this.getPersistentData().getIntOr("mafishcrossbow_bounceLeft", 0)) <= 0) {
            Vec3 normal = blockHit.getDirection().getUnitVec3();
            Vec3 shootDir = this.reflectDir(normal);
            this.explodeAndCleanup(shootDir, blockHit.getLocation());
        }
    }

    @Override
    protected void afterHitEntity(EntityHitResult entityHit) {
        int bounceLeft;
        if (this.isRemoved()) {
            return;
        }
        if (!this.level().isClientSide && (bounceLeft = this.getPersistentData().getIntOr("mafishcrossbow_bounceLeft", 0)) <= 0) {
            Vec3 normal = this.position().subtract(entityHit.getEntity().position()).normalize();
            Vec3 shootDir = this.reflectDir(normal);
            this.explodeAndCleanup(shootDir, entityHit.getEntity().position());
        }
    }

    private Vec3 reflectDir(Vec3 normal) {
        Vec3 incoming = this.getDeltaMovement().normalize();
        return incoming.subtract(normal.scale(2.0 * incoming.dot(normal)));
    }

    private void explodeAndCleanup(Vec3 dir, Vec3 hitPos) {
        this.triggerNestedFire(hitPos, dir);
        if (!this.level().isClientSide && this.shouldDropOnHit) {
            this.dropCrossbowAfterFire();
        }
        this.discard();
    }

    private void triggerNestedFire(Vec3 spawnPos, Vec3 direction) {
        LivingEntity l;
        Entity entity;
        if (this.level().isClientSide) {
            return;
        }
        ItemStack carriedCrossbow = this.getCarriedCrossbow();
        if (!(carriedCrossbow.getItem() instanceof CrossbowItem)) {
            return;
        }
        ChargedProjectiles component = (ChargedProjectiles)carriedCrossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (component == null || component.getItems().isEmpty()) {
            return;
        }
        List loaded = component.getItems();
        StaticShooterContext context = new StaticShooterContext(spawnPos, direction.normalize(), (entity = this.getOwner()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.sourceHasInfinity);
        List<Vec3> directions = CrossbowScatterUtil.computeSphericalScatterDirections(direction.normalize(), loaded.size(), 15.0f, 7.0f);
        for (int i = 0; i < loaded.size(); ++i) {
            ItemStack ammo = (ItemStack)loaded.get(i);
            Vec3 fireDir = directions.get(i);
            Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(this.level(), context, carriedCrossbow, ammo);
            if (proj == null) continue;
            if (this.sourceHasInfinity) {
                InfinityHelper.markAsInfinitySource(proj);
                if (proj instanceof FiredCrossbowProjectile) {
                    FiredCrossbowProjectile firedCrossbow = (FiredCrossbowProjectile)proj;
                    firedCrossbow.sourceHasInfinity = true;
                    firedCrossbow.shouldDropOnHit = false;
                }
            }
            proj.setYRot((float)Math.toDegrees(Math.atan2(fireDir.x, fireDir.z)));
            proj.setXRot((float)Math.toDegrees(Math.atan2(fireDir.y, fireDir.horizontalDistance())));
            proj.setRot(proj.getYRot(), proj.getXRot());
            proj.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            proj.setDeltaMovement(fireDir.scale(3.0));
            int bowLeftLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWLEFT, carriedCrossbow);
            int bowRightLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWRIGHT, carriedCrossbow);
            if (bowLeftLevel > 0 && bowRightLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, -15.0f);
                proj.setDeltaMovement(rotatedMotion);
            } else if (bowRightLevel > 0 && bowLeftLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, 15.0f);
                proj.setDeltaMovement(rotatedMotion);
            }
            this.level().addFreshEntity((Entity)proj);
        }
    }

    private void dropCrossbowAfterFire() {
        ItemStack original = this.getCarriedCrossbow();
        if (original.isEmpty()) {
            return;
        }
        ItemStack dropped = original.copy();
        dropped.remove(DataComponents.CHARGED_PROJECTILES);
        dropped.hurtWithoutBreaking(1, null);
        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), dropped));
    }

    public ItemStack getCarriedCrossbow() {
        ItemStack fromEntityData = (ItemStack)this.entityData.get(CARRIED_CROSSBOW);
        if (fromEntityData.isEmpty()) {
            return this.getItem();
        }
        return fromEntityData;
    }

    public void setCarriedCrossbow(ItemStack stack) {
        this.entityData.set(CARRIED_CROSSBOW, (Object)stack);
    }

    private Vec3 rotateYaw(Vec3 vec, float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        double newX = vec.x * (double)cos - vec.z * (double)sin;
        double newZ = vec.x * (double)sin + vec.z * (double)cos;
        return new Vec3(newX, vec.y, newZ);
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        out.store(TAG_CROSSBOW, ItemStack.CODEC, (Object)this.getCarriedCrossbow());
        out.putBoolean(TAG_DROP, this.shouldDropOnHit);
        out.putBoolean(TAG_SOURCE_INFINITY, this.sourceHasInfinity);
    }

    protected void readAdditionalSaveData(ValueInput in) {
        super.readAdditionalSaveData(in);
        ItemStack crossbow = in.read(TAG_CROSSBOW, ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.setCarriedCrossbow(crossbow);
        this.shouldDropOnHit = in.getBooleanOr(TAG_DROP, true);
        this.sourceHasInfinity = in.getBooleanOr(TAG_SOURCE_INFINITY, false);
    }
}

