/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TEditBox;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentEntryPanel
extends TPanel {
    private final Holder<Enchantment> enchantment;
    private int level;
    private final int maxLevel;
    private final boolean isCreative;
    private final TLabel nameLabel;
    private final TButton decreaseButton;
    private final TEditBox levelBox;
    private final TButton increaseButton;
    private final TButton removeButton;
    private Consumer<EnchantmentEntryPanel> onLevelChanged;
    private Consumer<EnchantmentEntryPanel> onRemoved;
    private boolean updatingLevelBox = false;

    public EnchantmentEntryPanel(Holder<Enchantment> enchantment, int level, boolean isCreative) {
        this.enchantment = enchantment;
        this.level = level;
        this.isCreative = isCreative;
        this.maxLevel = isCreative ? 255 : ((Enchantment)enchantment.value()).getMaxLevel();
        this.nameLabel = new TLabel(this.getEnchantmentName());
        this.decreaseButton = new TButton((Component)Component.literal((String)"-"));
        this.decreaseButton.setOnPress(this::onDecrease);
        this.levelBox = new TEditBox();
        this.increaseButton = new TButton((Component)Component.literal((String)"+"));
        this.increaseButton.setOnPress(this::onIncrease);
        this.removeButton = new TButton((Component)Component.literal((String)"\u00d7"));
        this.removeButton.setOnPress(this::onRemove);
        this.levelBox.setMaxLength(3);
        this.levelBox.setFilter(s -> s.isEmpty() || s.matches("\\d+"));
        this.levelBox.setEditable(true);
        this.levelBox.addResponder(this::onLevelInput);
        this.levelBox.setValue(String.valueOf(level));
        this.decreaseButton.setMessage((Component)Component.literal((String)"-"));
        this.increaseButton.setMessage((Component)Component.literal((String)"+"));
        this.removeButton.setMessage((Component)Component.literal((String)"\u00d7"));
        this.nameLabel.setFontSize(6.0f);
        this.add(this.nameLabel);
        this.add(this.decreaseButton);
        this.add(this.levelBox);
        this.add(this.increaseButton);
        this.add(this.removeButton);
        this.setBackground(0x40000000);
    }

    private Component getEnchantmentName() {
        return Enchantment.getFullname(this.enchantment, (int)this.level);
    }

    @Override
    public void layout() {
        this.nameLabel.setBounds(2, 1, this.width - 4, 12);
        int controlY = 14;
        int controlWidth = 14;
        int boxWidth = 30;
        int totalControlWidth = controlWidth + boxWidth + controlWidth + controlWidth;
        int startX = (this.width - totalControlWidth) / 2;
        this.decreaseButton.setBounds(startX, controlY, controlWidth, 14);
        this.levelBox.setBounds(startX + controlWidth + 1, controlY + 1, boxWidth, 12);
        this.increaseButton.setBounds(startX + controlWidth + boxWidth + 2, controlY, controlWidth, 14);
        this.removeButton.setBounds(startX + controlWidth + boxWidth + controlWidth + 3, controlY, controlWidth, 14);
        super.layout();
        this.levelBox.layout();
        int savedCursorPos = this.levelBox.getCursorPosition();
        this.levelBox.moveCursorToEnd(false);
        this.levelBox.setCursorPosition(savedCursorPos);
    }

    private void onDecrease(Button button) {
        if (this.level > 1) {
            this.setLevel(this.level - 1);
            this.notifyLevelChanged();
        }
    }

    private void onIncrease(Button button) {
        int effectiveMaxLevel;
        int n = effectiveMaxLevel = this.isCreative ? 255 : this.maxLevel;
        if (this.level < effectiveMaxLevel) {
            this.setLevel(this.level + 1);
            this.notifyLevelChanged();
        }
    }

    private void onRemove(Button button) {
        if (this.onRemoved != null) {
            this.onRemoved.accept(this);
        }
    }

    private void onLevelInput(String value) {
        block5: {
            if (this.updatingLevelBox) {
                return;
            }
            try {
                int effectiveMaxLevel;
                int newLevel = Integer.parseInt(value);
                int n = effectiveMaxLevel = this.isCreative ? 255 : this.maxLevel;
                if (newLevel >= 1 && newLevel <= effectiveMaxLevel) {
                    this.level = newLevel;
                    this.nameLabel.setText(this.getEnchantmentName());
                    this.notifyLevelChanged();
                } else {
                    this.updatingLevelBox = true;
                    this.levelBox.setValue(String.valueOf(this.level));
                    this.updatingLevelBox = false;
                }
            }
            catch (NumberFormatException e) {
                if (value.isEmpty()) break block5;
                this.updatingLevelBox = true;
                this.levelBox.setValue(String.valueOf(this.level));
                this.updatingLevelBox = false;
            }
        }
    }

    private void setLevel(int newLevel) {
        this.level = newLevel;
        this.updatingLevelBox = true;
        this.levelBox.setValue(String.valueOf(newLevel));
        this.updatingLevelBox = false;
        this.nameLabel.setText(this.getEnchantmentName());
    }

    private void notifyLevelChanged() {
        if (this.onLevelChanged != null) {
            this.onLevelChanged.accept(this);
        }
    }

    public Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    public int getLevel() {
        return this.level;
    }

    public void setOnLevelChanged(Consumer<EnchantmentEntryPanel> onLevelChanged) {
        this.onLevelChanged = onLevelChanged;
    }

    public void setOnRemoved(Consumer<EnchantmentEntryPanel> onRemoved) {
        this.onRemoved = onRemoved;
    }
}

