/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import cn.ussshenzhou.t88.gui.container.TVerticalScrollContainer;
import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TSelectList;
import com.mafuyu33.mafishcrossbow.a_tabs.ModTabs;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentDisplayEntry;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentEntryPanel;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentTableMenu;
import com.mafuyu33.mafishcrossbow.network.packet.C2S.EnchantmentModifyC2SPacket;
import com.mafuyu33.mafishcrossbow.network.packet.C2S.ItemRenameC2SPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EnchantmentTableScreen
extends AbstractContainerScreen<EnchantmentTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/anvil.png");
    private static final ResourceLocation TEXT_FIELD_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/anvil/text_field");
    private static final ResourceLocation TEXT_FIELD_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/anvil/text_field_disabled");
    private final TLabel currentEnchantmentsLabel;
    private final TVerticalScrollContainer currentEnchantmentsPanel;
    private final List<EnchantmentEntryPanel> enchantmentEntries = new ArrayList<EnchantmentEntryPanel>();
    private final TLabel availableEnchantmentsLabel;
    private final TSelectList<EnchantmentDisplayEntry> availableEnchantmentsList;
    private final TButton addEnchantmentButton;
    private final TLabel expCostLabel;
    private EditBox nameEditBox;
    private ItemEnchantments.Mutable tempEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
    private ItemStack lastInputItem = ItemStack.EMPTY;
    private ItemStack lastMafishItem = ItemStack.EMPTY;

    public EnchantmentTableScreen(EnchantmentTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
        this.imageWidth = 176;
        this.currentEnchantmentsLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.enchantment_table.current_enchantments"));
        this.currentEnchantmentsPanel = new TVerticalScrollContainer();
        this.currentEnchantmentsPanel.setBackground(Integer.MIN_VALUE);
        this.currentEnchantmentsPanel.setBorder(new Border(-7631989, 1));
        this.availableEnchantmentsLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.enchantment_table.available_enchantments"));
        this.availableEnchantmentsList = new TSelectList(15, 0);
        this.availableEnchantmentsList.setBackground(Integer.MIN_VALUE);
        this.addEnchantmentButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.add_enchantment"));
        this.addEnchantmentButton.setOnPress(this::onAddEnchantment);
        this.expCostLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.exp_cost", (Object[])new Object[]{0}));
        this.expCostLabel.setForeground(-8323296);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int relX = this.leftPos;
        int relY = this.topPos;
        this.nameEditBox = new EditBox(this.font, relX + 62, relY + 24, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.nameEditBox.setCanLoseFocus(false);
        this.nameEditBox.setTextColor(-1);
        this.nameEditBox.setTextColorUneditable(-1);
        this.nameEditBox.setBordered(false);
        this.nameEditBox.setMaxLength(50);
        this.nameEditBox.setValue("");
        this.addRenderableWidget((GuiEventListener)this.nameEditBox);
        this.currentEnchantmentsLabel.setFontSize(7.0f);
        this.availableEnchantmentsLabel.setFontSize(7.0f);
        this.expCostLabel.setFontSize(7.0f);
        this.currentEnchantmentsLabel.setAbsBounds(relX - 95, relY + 10, 90, 20);
        this.currentEnchantmentsPanel.setAbsBounds(relX - 95, relY + 32, 90, 120);
        this.availableEnchantmentsLabel.setAbsBounds(relX + 181, relY + 10, 90, 20);
        this.availableEnchantmentsList.setAbsBounds(relX + 181, relY + 32, 90, 120);
        this.loadAvailableEnchantments();
        this.currentEnchantmentsLabel.setParentScreen(null);
        this.currentEnchantmentsPanel.setParentScreen(null);
        this.availableEnchantmentsLabel.setParentScreen(null);
        this.availableEnchantmentsList.setParentScreen(null);
        this.expCostLabel.setParentScreen(null);
    }

    private void loadAvailableEnchantments() {
        this.availableEnchantmentsList.clearElement();
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            Registry registry = mc.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            for (ResourceLocation id : ModTabs.ENCHANTMENT_TO_ADD) {
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
                registry.get(key).ifPresent(holder -> {
                    Component name = Enchantment.getFullname((Holder)holder, (int)1);
                    this.availableEnchantmentsList.addElement(new EnchantmentDisplayEntry(id, name));
                });
            }
        }
    }

    public void containerTick() {
        ItemStack currentMafish;
        super.containerTick();
        ItemStack currentInput = ((EnchantmentTableMenu)this.menu).getInputItem();
        if (!ItemStack.matches((ItemStack)currentInput, (ItemStack)this.lastInputItem)) {
            this.lastInputItem = currentInput.copy();
            this.loadEnchantmentsFromInput();
            if (!currentInput.isEmpty()) {
                this.nameEditBox.setValue(currentInput.getHoverName().getString());
                this.nameEditBox.setEditable(this.hasMafish());
            } else {
                this.nameEditBox.setValue("");
                this.nameEditBox.setEditable(false);
            }
        }
        if (!ItemStack.matches((ItemStack)(currentMafish = ((EnchantmentTableMenu)this.menu).getContainer().getItem(1)), (ItemStack)this.lastMafishItem)) {
            this.lastMafishItem = currentMafish.copy();
            if (!currentInput.isEmpty()) {
                this.nameEditBox.setEditable(this.hasMafish());
            }
        }
        this.layoutComponents();
        this.currentEnchantmentsPanel.tickT();
        this.availableEnchantmentsList.tickT();
    }

    private boolean hasMafish() {
        return ((EnchantmentTableMenu)this.menu).getSlot(1).hasItem();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.currentEnchantmentsPanel.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.nameEditBox.keyPressed(keyCode, scanCode, modifiers)) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ItemRenameC2SPacket(this.nameEditBox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.currentEnchantmentsPanel.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.nameEditBox.charTyped(codePoint, modifiers)) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ItemRenameC2SPacket(this.nameEditBox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private void layoutComponents() {
        this.currentEnchantmentsLabel.layout();
        this.currentEnchantmentsPanel.layout();
        this.availableEnchantmentsLabel.layout();
        this.availableEnchantmentsList.layout();
        this.addEnchantmentButton.layout();
        this.expCostLabel.layout();
    }

    private void loadEnchantmentsFromInput() {
        ItemStack input = ((EnchantmentTableMenu)this.menu).getInputItem();
        if (!input.isEmpty() && EnchantmentHelper.canStoreEnchantments((ItemStack)input)) {
            Map<Holder<Enchantment>, Integer> serverTempEnchants = ((EnchantmentTableMenu)this.menu).getTempEnchantments();
            this.tempEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            if (serverTempEnchants.isEmpty()) {
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
                for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                    this.tempEnchantments.set((Holder)entry.getKey(), entry.getIntValue());
                }
            } else {
                for (Map.Entry<Holder<Enchantment>, Integer> entry : serverTempEnchants.entrySet()) {
                    this.tempEnchantments.set(entry.getKey(), entry.getValue().intValue());
                }
            }
            this.updateEnchantmentEntries();
        } else {
            this.tempEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            this.updateEnchantmentEntries();
        }
    }

    private void updateEnchantmentEntries() {
        this.enchantmentEntries.forEach(this.currentEnchantmentsPanel::remove);
        this.enchantmentEntries.clear();
        boolean isCreative = Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasInfiniteMaterials();
        int yOffset = 3;
        for (Object2IntMap.Entry entry : this.tempEnchantments.toImmutable().entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            int level = entry.getIntValue();
            EnchantmentEntryPanel panel = new EnchantmentEntryPanel((Holder<Enchantment>)enchantment, level, isCreative);
            panel.setOnLevelChanged(this::onEnchantmentLevelChanged);
            panel.setOnRemoved(this::onEnchantmentRemoved);
            panel.setAbsBounds(this.currentEnchantmentsPanel.getXT() + 3, this.currentEnchantmentsPanel.getYT() + yOffset, this.currentEnchantmentsPanel.getWidth() - 12, 29);
            this.currentEnchantmentsPanel.add(panel);
            this.enchantmentEntries.add(panel);
            yOffset += 30;
        }
    }

    private void onEnchantmentLevelChanged(EnchantmentEntryPanel panel) {
        Holder<Enchantment> enchantment = panel.getEnchantment();
        int newLevel = panel.getLevel();
        this.tempEnchantments.set(enchantment, newLevel);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EnchantmentModifyC2SPacket(EnchantmentModifyC2SPacket.Operation.SET_LEVEL, enchantment.getKey().location(), newLevel), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void onEnchantmentRemoved(EnchantmentEntryPanel panel) {
        Holder<Enchantment> enchantment = panel.getEnchantment();
        this.tempEnchantments.removeIf(holder -> holder.equals((Object)enchantment));
        this.updateEnchantmentEntries();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EnchantmentModifyC2SPacket(EnchantmentModifyC2SPacket.Operation.REMOVE, enchantment.getKey().location(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void onAddEnchantment(Button button) {
        TSelectList.Entry selected = (TSelectList.Entry)this.availableEnchantmentsList.getSelected();
        if (selected != null) {
            ResourceLocation enchantmentId = ((EnchantmentDisplayEntry)selected.getContent()).id();
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                Registry registry = mc.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                Optional enchantmentOpt = registry.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchantmentId));
                enchantmentOpt.ifPresent(enchantmentHolder -> {
                    if (!this.tempEnchantments.keySet().contains(enchantmentHolder)) {
                        this.tempEnchantments.set((Holder)enchantmentHolder, 1);
                        this.updateEnchantmentEntries();
                        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EnchantmentModifyC2SPacket(EnchantmentModifyC2SPacket.Operation.ADD, enchantmentId, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                });
            }
        }
    }

    private void updateResultItem() {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ((EnchantmentTableMenu)this.menu).getInputItem().isEmpty() ? TEXT_FIELD_DISABLED_SPRITE : TEXT_FIELD_SPRITE, this.leftPos + 59, this.topPos + 20, 110, 16);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (!this.hasMafish() && !((EnchantmentTableMenu)this.menu).getInputItem().isEmpty()) {
            MutableComponent hint = Component.translatable((String)"gui.mafishcrossbow.need_mafish");
            int hintX = this.imageWidth - 8 - this.font.width((FormattedText)hint) - 2;
            int hintY = 69;
            guiGraphics.fill(hintX - 2, 67, this.imageWidth - 8, 79, 0x4F000000);
            guiGraphics.drawString(this.font, (Component)hint, hintX, hintY, -40864);
            return;
        }
        if (!((EnchantmentTableMenu)this.menu).getInputItem().isEmpty() && this.hasMafish()) {
            int totalCost = 0;
            for (Object2IntMap.Entry entry : this.tempEnchantments.toImmutable().entrySet()) {
                totalCost += entry.getIntValue();
            }
            MutableComponent costText = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{totalCost});
            int textColor = -8323296;
            int textX = this.imageWidth - 8 - this.font.width((FormattedText)costText) - 2;
            int textY = 69;
            guiGraphics.fill(textX - 2, 67, this.imageWidth - 8, 79, 0x4F000000);
            guiGraphics.drawString(this.font, (Component)costText, textX, textY, textColor);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.currentEnchantmentsLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.currentEnchantmentsPanel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.availableEnchantmentsLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.availableEnchantmentsList.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.currentEnchantmentsPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.hasMafish()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.availableEnchantmentsList.mouseClicked(mouseX, mouseY, button)) {
            TSelectList.Entry selected = (TSelectList.Entry)this.availableEnchantmentsList.getSelected();
            if (selected != null && button == 0) {
                this.onAddEnchantment(null);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.currentEnchantmentsPanel.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        if (this.availableEnchantmentsList.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }
}

