/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinitearrow;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class BlockTemporaryMixin {
    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventTemporaryBlockDropBasic(BlockState state, Level level, BlockPos pos, CallbackInfo ci) {
        if (TemporaryBlockTracker.isTemporary((LevelReader)level, pos)) {
            ci.cancel();
        }
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventTemporaryBlockDropWithBlockEntity(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, CallbackInfo ci) {
        Level l;
        if (level instanceof Level && TemporaryBlockTracker.isTemporary((LevelReader)(l = (Level)level), pos)) {
            ci.cancel();
        }
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventTemporaryBlockDropFull(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack tool, CallbackInfo ci) {
        if (TemporaryBlockTracker.isTemporary((LevelReader)level, pos)) {
            ci.cancel();
        }
    }

    @Inject(method={"popResource"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventTemporaryBlockPopResource(Level level, BlockPos pos, ItemStack stack, CallbackInfo ci) {
        if (TemporaryBlockTracker.isTemporary((LevelReader)level, pos)) {
            ci.cancel();
        }
    }
}

